###################################################
### chunk number 1: family-data
###################################################
#line 52 "tdt-vignette.Rnw"
require(chopsticks)
data(families)
head(genotypes)
head(pedfile)


###################################################
### chunk number 2: mis-inheritances
###################################################
#line 73 "tdt-vignette.Rnw"
mis <- misinherits(data=pedfile, snp.data=genotypes)
dim(mis)


###################################################
### chunk number 3: per-subj-snp
###################################################
#line 82 "tdt-vignette.Rnw"
per.subj <- apply(mis, 1, sum, na.rm=TRUE)
per.snp <- apply(mis, 2, sum, na.rm=TRUE)
par(mfrow = c(1, 2))
hist(per.subj,main='Histogram per Subject', xlab='Subject')
hist(per.snp,main='Histogram per SNP', xlab='SNP')


###################################################
### chunk number 4: per-family
###################################################
#line 94 "tdt-vignette.Rnw"
fam <- pedfile[rownames(mis), "familyid"]
per.fam <- tapply(per.subj, fam, sum)
par(mfrow = c(1, 1))
hist(per.fam, main='Histogram per Family', xlab='Family')


###################################################
### chunk number 5: tdt-tests
###################################################
#line 113 "tdt-vignette.Rnw"
tests <- tdt.snp(data = pedfile, snp.data = genotypes)
cbind(p.values.1df = p.value(tests, 1),
      p.values.2df = p.value(tests, 2))
qq.chisq(chi.squared(tests, 1), df = 1)


