###################################################
### chunk number 1: options
###################################################
#line 118 "arrayQualityMetrics.Rnw"
options(error = recover, warn = 2)


###################################################
### chunk number 2: DataLoading
###################################################
#line 133 "arrayQualityMetrics.Rnw"
library("ALLMLL")
data("MLL.A")


###################################################
### chunk number 3: AffyBatchQM
###################################################
#line 144 "arrayQualityMetrics.Rnw"
library("arrayQualityMetrics")
arrayQualityMetrics(expressionset = MLL.A[, 1:5],
                    outdir = "Report_for_MLL_A",
                    force = TRUE,
                    do.logtransform = TRUE)


###################################################
### chunk number 4: Normalisation
###################################################
#line 172 "arrayQualityMetrics.Rnw"
nMLL = rma(MLL.A)


###################################################
### chunk number 5: ExpressionSet
###################################################
#line 178 "arrayQualityMetrics.Rnw"
arrayQualityMetrics(expressionset = nMLL,
                    outdir = "Report_for_nMLL",
                    force = TRUE)


###################################################
### chunk number 6: NChannelSet
###################################################
#line 213 "arrayQualityMetrics.Rnw"
library("vsn")
library("CCl4")
data("CCl4")
nCCl4 = justvsn(CCl4, subsample = 2000)
arrayQualityMetrics(expressionset = nCCl4,
                    outdir = "Report_for_nCCl4",
                    force = TRUE)


###################################################
### chunk number 7: intgroup1
###################################################
#line 254 "arrayQualityMetrics.Rnw"
pData(nMLL)$condition = rep(letters[1:4], times = 5)
pData(nMLL)$batch = rep(paste(1:4), each = 5)


###################################################
### chunk number 8: intgroup2
###################################################
#line 258 "arrayQualityMetrics.Rnw"
arrayQualityMetrics(expressionset = nMLL,
                    outdir = "Report_for_nMLL_with_factors",
                    force = TRUE,
                    intgroup = c("condition", "batch"))


###################################################
### chunk number 9: XYcoordinates
###################################################
#line 294 "arrayQualityMetrics.Rnw"
featureData(nCCl4)$X = featureData(nCCl4)$Row
featureData(nCCl4)$Y = featureData(nCCl4)$Column


###################################################
### chunk number 10: hasTarget
###################################################
#line 314 "arrayQualityMetrics.Rnw"
featureData(nCCl4)$hasTarget = (regexpr("^NM", featureData(nCCl4)$Name) > 0)
table(featureData(nCCl4)$hasTarget)


###################################################
### chunk number 11: pData
###################################################
#line 341 "arrayQualityMetrics.Rnw"
pd = pData(CCl4)
rownames(pd) = NULL
pd              


###################################################
### chunk number 12: RIN
###################################################
#line 349 "arrayQualityMetrics.Rnw"
RIN = with(pd, ifelse( Cy3=="CCl4", RIN.Cy3, RIN.Cy5))
fRIN = factor(RIN)
levels(fRIN) = c("poor", "medium", "good")
pData(nCCl4)$"RNA-integrity" = fRIN


###################################################
### chunk number 13: NChannelSet
###################################################
#line 359 "arrayQualityMetrics.Rnw"
arrayQualityMetrics(expressionset = nCCl4,
                    outdir = "Report_for_nCCl4_with_RIN",
                    force = TRUE,
                    intgroup = "RNA-integrity")


###################################################
### chunk number 14: pkgs
###################################################
#line 371 "arrayQualityMetrics.Rnw"
toLatex(sessionInfo())


