###################################################
### chunk number 1: 
###################################################
#line 28 "aqm.Rnw"
options(error=recover)


###################################################
### chunk number 2: loading
###################################################
#line 56 "aqm.Rnw"
library("arrayQualityMetrics")
library("ALLMLL")
data("MLL.A")


###################################################
### chunk number 3: DataPreparation
###################################################
#line 72 "aqm.Rnw"
preparedData = prepdata(expressionset = MLL.A, 
                    intgroup = c(), 
                    do.logtransform = TRUE)


###################################################
### chunk number 4:  eval=FALSE
###################################################
## #line 89 "aqm.Rnw"
## ?aqm.boxplot


###################################################
### chunk number 5: metrics
###################################################
#line 96 "aqm.Rnw"
bo = aqm.boxplot(preparedData)
de = aqm.density(preparedData)
qm = list("Boxplot" = bo, "Density" = de)


###################################################
### chunk number 6: booutliers
###################################################
#line 120 "aqm.Rnw"
bo@outliers


###################################################
### chunk number 7: shortReport
###################################################
#line 152 "aqm.Rnw"
outdir = tempdir()
aqm.writereport(modules = qm, reporttitle = "My example", outdir = outdir, 
                arrayTable = pData(MLL.A))
outdir


###################################################
### chunk number 8: pkgs
###################################################
#line 164 "aqm.Rnw"
toLatex(sessionInfo())


