###################################################
### chunk number 1: citation
###################################################
#line 50 "affypdnn.Rnw"
citation(package="affypdnn")


###################################################
### chunk number 2: init
###################################################
#line 61 "affypdnn.Rnw"
library(affypdnn)


###################################################
### chunk number 3: afbatch
###################################################
#line 72 "affypdnn.Rnw"
library(affydata)
data(Dilution)
afbatch <- Dilution


###################################################
### chunk number 4: hgu95av2Params
###################################################
#line 95 "affypdnn.Rnw"
data(hgu95av2.pdnn.params)

params.chiptype <- hgu95av2.pdnn.params


###################################################
### chunk number 5: energyFiles
###################################################
#line 110 "affypdnn.Rnw"
dir(system.file("exampleData", package="affypdnn"))


###################################################
### chunk number 6: experimentSpecific
###################################################
#line 134 "affypdnn.Rnw"
data("params.dilution", package="affypdnn")
params <- params.dilution
rm(params.dilution)


###################################################
### chunk number 7: pmLevel
###################################################
#line 148 "affypdnn.Rnw"
ppset.name <- c("41206_r_at", "31620_at")
ppset <- probeset(afbatch, ppset.name)


###################################################
### chunk number 8: pmLevelPlot
###################################################
#line 160 "affypdnn.Rnw"
par(mfrow=c(2,2))
for (i in 1:2) {
  probes.pdnn <- pmcorrect.pdnnpredict(ppset[[i]], params,
                                       params.chiptype = params.chiptype)

  plot(ppset[[i]], main=paste(ppset.name[i], "\n(raw intensities)"))
  matplotProbesPDNN(probes.pdnn, 
                    main = paste(ppset.name[i], 
                      "\n(predicted intensities)"))
}


###################################################
### chunk number 9: expressopdnn
###################################################
#line 188 "affypdnn.Rnw"
ids <- ls(getCdfInfo(afbatch))[1:10]
eset <- expressopdnn(afbatch, 
                     bg.correct = FALSE,
                     normalize = FALSE,
                     findparams.param = list(params.chiptype = params.chiptype,
                       give.warnings=FALSE),
                     summary.subset=ids)


