###################################################
### chunk number 1: 
###################################################
#line 43 "tr_2005_02.Rnw"
library(golubEsets)
oldopt <- options(digits=3)
on.exit( {options(oldopt)} )
options(width=70)
if (interactive()) { 
    options(error=recover)
}
set.seed(123)


###################################################
### chunk number 2: 
###################################################
#line 150 "tr_2005_02.Rnw"
library(adSplit) 


###################################################
### chunk number 3: 
###################################################
#line 159 "tr_2005_02.Rnw"
library(golubEsets) 
data(Golub_Merge) 


###################################################
### chunk number 4: 
###################################################
#line 185 "tr_2005_02.Rnw"
e <- exprs(Golub_Merge)
vars <- apply(e, 1, var)
e <- e[vars > quantile(vars,0.9),]

diana2means(e)
diana2means(e, return.cut=TRUE)


###################################################
### chunk number 5: 
###################################################
#line 200 "tr_2005_02.Rnw"
x <- diana2means(e, return.cut=TRUE)
x$cut


###################################################
### chunk number 6: 
###################################################
#line 218 "tr_2005_02.Rnw"
adSplit(Golub_Merge, "GO:0006915", "hu6800")


###################################################
### chunk number 7: 
###################################################
#line 232 "tr_2005_02.Rnw"
adSplit(Golub_Merge, "GO:0007165", "hu6800")


###################################################
### chunk number 8: 
###################################################
#line 241 "tr_2005_02.Rnw"
adSplit(Golub_Merge, "GO:0007165", "hu6800", max.probes=7000)


###################################################
### chunk number 9: 
###################################################
#line 287 "tr_2005_02.Rnw"
EID2PSenv <- makeEID2PROBESenv(hu6800ENTREZID)


###################################################
### chunk number 10: 
###################################################
#line 294 "tr_2005_02.Rnw"
drawRandomPS(10, EID2PSenv, ls(EID2PSenv))


###################################################
### chunk number 11: 
###################################################
#line 309 "tr_2005_02.Rnw"
scores <- randomDiana2means(20, exprs(Golub_Merge), "hu6800", ndraws = 1000) 


###################################################
### chunk number 12: 
###################################################
#line 320 "tr_2005_02.Rnw"
scores2 <- randomDiana2means(20, exprs(Golub_Merge), "hu6800", 
                            ndraws = 1000, ignore.genes=5) 
par(mfrow=c(1,2))
hist(scores,  nclass=30, main="", col="grey")
hist(scores2, nclass=30, main="", col="grey")


###################################################
### chunk number 13: 
###################################################
#line 338 "tr_2005_02.Rnw"
glutamSplits <- adSplit(Golub_Merge, "KEGG:00251", "hu6800", B=1000) 


###################################################
### chunk number 14: 
###################################################
#line 347 "tr_2005_02.Rnw"
print(glutamSplits)


###################################################
### chunk number 15: 
###################################################
#line 361 "tr_2005_02.Rnw"
x <- adSplit(Golub_Merge, c("GO:0007165","GO:0006915"), "hu6800", max.probes=7000)
print(x)


###################################################
### chunk number 16: 
###################################################
#line 379 "tr_2005_02.Rnw"
x <- adSplit(Golub_Merge, "KEGG", "hu6800")


###################################################
### chunk number 17: 
###################################################
#line 382 "tr_2005_02.Rnw"
print(x)


###################################################
### chunk number 18: 
###################################################
#line 388 "tr_2005_02.Rnw"
data(golubKEGGSplits)
print(golubKEGGSplits)
summary(golubKEGGSplits$qvalues)


###################################################
### chunk number 19: 
###################################################
#line 422 "tr_2005_02.Rnw"
data(golubKEGGSplits)
hist(golubKEGGSplits)


###################################################
### chunk number 20: 
###################################################
#line 438 "tr_2005_02.Rnw"
image(golubKEGGSplits, filter.fdr=0.3, outfile="splitSet.eps", res=300)


