###################################################
### chunk number 1: code1
###################################################
#line 62 "turbonorm.Rnw"
library(TurboNorm)
funky <- function(x) sin(2*pi*x^3)^3
m <- 100
x <- seq(0, 1, length=m)
y <- funky(x) + rnorm(m, 0, 0.1)


###################################################
### chunk number 2: code2
###################################################
#line 72 "turbonorm.Rnw"
plot(x, y, type='p', xlab="", ylab="")
curve(funky, add=TRUE)

fitOrig <- turbotrend(x, y, n=15, method="original")
lines(fitOrig, col="green", type='b', pch=1)


###################################################
### chunk number 3: code3
###################################################
#line 82 "turbonorm.Rnw"
fitOrig


###################################################
### chunk number 4: code4
###################################################
#line 94 "turbonorm.Rnw"
library(marray)
data(swirl)
x <- pspline(swirl, showArrays=2, pch=20, col="grey")


###################################################
### chunk number 5: code5
###################################################
#line 107 "turbonorm.Rnw"
library(TurboNorm)
data(methylation)

indices <- methylation$weights[,1]
weights <- rep(1, length(indices))
weights[indices] <- length(indices)/sum(indices)

MA <- normalizeWithinArrays(methylation, method="none", bc.method="none")

labels <- paste("NMB", c("(untreated)", "(treated)"))
labels <- paste(rep(c("Raw"), each=2), labels)



###################################################
### chunk number 6: code6
###################################################
#line 124 "turbonorm.Rnw"

data <- data.frame(M=as.vector(MA$M), 
                   A=as.vector(MA$A), 
                   Array=factor(rep(labels, each=nrow(MA$A)), levels=rev(labels)))

library(lattice)

print(xyplot(M~A|Array, xlab="", ylab="", data=data, type='g', 
        panel = function(x, y) {
                panel.xyplot(x, y, col="grey")
								lpoints(x[indices], y[indices], pch=20, col="black")
								panel.pspline(x, y, weights = weights, col="red", lwd=2)
								panel.loess(x, y, col="green", lwd=2)								
            }))


###################################################
### chunk number 7: code7
###################################################
#line 147 "turbonorm.Rnw"
toLatex(sessionInfo())


