###################################################
### chunk number 1: loadlibs
###################################################
#line 48 "vignette.Rnw"
library("ScISI")


###################################################
### chunk number 2: getGOInfo
###################################################
#line 65 "vignette.Rnw"
goECodes = c("IEA", "NAS", "ND", "NR")
go = getGOInfo(wantDefault = TRUE, toGrep = NULL, parseType=NULL, 
               eCode = goECodes, wantAllComplexes = TRUE)


###################################################
### chunk number 3: getGOInfoToGrep
###################################################
#line 104 "vignette.Rnw"
toBeParsed = list()
toBeParsed$pattern = "\\Bsomal\\b"
goGrep = getGOInfo(wantDefault = TRUE, toGrep = toBeParsed, parseType = "grep",
                   eCode = NULL, wantAllComplexes = TRUE)
getGOTerm(setdiff(names(goGrep), names(go)))



###################################################
### chunk number 4: getGOInfoOut
###################################################
#line 130 "vignette.Rnw"
class(go)
names(go)[1:5]
go$"GO:0005830"


###################################################
### chunk number 5: createGOMatrix
###################################################
#line 151 "vignette.Rnw"
goM = list2Matrix(go)


###################################################
### chunk number 6: getMipsInfo
###################################################
#line 177 "vignette.Rnw"
mips = getMipsInfo(wantDefault = TRUE, toGrep = NULL, parseType = NULL, 
                   eCode = NULL, wantSubComplexes = TRUE, ht=FALSE)


###################################################
### chunk number 7: getMipsInfoToGrep
###################################################
#line 213 "vignette.Rnw"
toBeParsed = list()
toBeParsed$pattern = "\\Bsomal\\b"
mipsGrep = getMipsInfo(wantDefault = TRUE, toGrep = toBeParsed, parseType = "grep",
                       eCode = NULL, wantSubComplexes = TRUE)
#mNm = setdiff(names(mipsGrep$Mips), names(mips$Mips))
#mId = strsplit(mNm, split = "-")
#sapply(mId, function(q) mipsGrep$DESC[q[2]])


###################################################
### chunk number 8: mipsInfo
###################################################
#line 254 "vignette.Rnw"
class(mips)
names(mips)


###################################################
### chunk number 9: getMipsInfoMips
###################################################
#line 263 "vignette.Rnw"
class(mips)
names(mips)[1:10]
mips$Mips$"MIPS-510.40"


###################################################
### chunk number 10: getMipsInfoDESC
###################################################
#line 272 "vignette.Rnw"
names(mips$DESC)[1:5]
mips$DESC["510.40"]


###################################################
### chunk number 11: createMipsMatrix
###################################################
#line 284 "vignette.Rnw"
mipsM = list2Matrix(mips)


###################################################
### chunk number 12: ppiData
###################################################
#line 305 "vignette.Rnw"
library("ppiData")
get("Gavin2006BPGraph")


###################################################
### chunk number 13: runCompareComplex
###################################################
#line 354 "vignette.Rnw"
mips2mips = runCompareComplex(mipsM, mipsM)
go2go = runCompareComplex(goM, goM)  
mips2go = runCompareComplex(mipsM, goM)
names(mips2go)


###################################################
### chunk number 14: runCompareComplexJC
###################################################
#line 386 "vignette.Rnw"
all(diag(mips2mips[["JC"]]) == 1)


###################################################
### chunk number 15: runCompareComplexMaxInterSect
###################################################
#line 417 "vignette.Rnw"
names(mips2go$maxIntersect)


###################################################
### chunk number 16: runCompareComplexMImaxComp
###################################################
#line 427 "vignette.Rnw"

mips2go$maxIntersect$maximize$row[1:3]
mips2go$maxIntersect$maxComp$row[1:3]



###################################################
### chunk number 17: runCompareComplexEqual
###################################################
#line 448 "vignette.Rnw"
length(mips2go$equal)
names(mips2go$equal[[1]])
mips2go$equal[[1]]


###################################################
### chunk number 18: runCompareComplexEqualMips
###################################################
#line 464 "vignette.Rnw"
ind = which(sapply(mips2mips$equal, function(w) w$BG1Comp != w$BG2Comp))
mips2mips$equal[ind]


###################################################
### chunk number 19: runCompareComplexSubC
###################################################
#line 504 "vignette.Rnw"
mips2mips$toBeRmSubC[1:3]
mips2go$toBeRmSubC[1:3]


###################################################
### chunk number 20: saveData
###################################################
#line 518 "vignette.Rnw"
save(mips2go, file="mips2go.rda", compress=TRUE)


###################################################
### chunk number 21: mergeBGMat
###################################################
#line 533 "vignette.Rnw"
  dim(mipsM)
  dim(goM)
  ISI = mergeBGMat(mipsM, goM, toBeRm = c(mips2go$toBeRm, mips2mips$toBeRm, go2go$toBeRm))
 


###################################################
### chunk number 22: dimISI
###################################################
#line 564 "vignette.Rnw"
dim(ISI)


###################################################
### chunk number 23: distPlot
###################################################
#line 587 "vignette.Rnw"
par(mfrow = c(1,2))
cS <- table(colSums(ISI))
size <- as.numeric(names(cS))
repet <- as.vector(cS)
freq = rep(size, repet)
hist(freq, xlab = "ScISI Protein Complex Cardinality", ylab = "Frequency",
     main = "Complex Cardinality")

rS <- table(rowSums(ISI))
size <- as.numeric(names(rS))
repet <- as.vector(rS)
freq = rep(size, repet)
hist(freq, xlab = "Complex Membership per Protein", ylab = "Frequency",
     main = "Complex Membership")
par(mfrow = c(1,1))


###################################################
### chunk number 24: testStuff
###################################################
#line 631 "vignette.Rnw"
data("redundantM")
data("subCompM")


###################################################
### chunk number 25: redundant
###################################################
#line 637 "vignette.Rnw"
library("xtable")
xtable(redundantM, display = c("s","d","d","d","d","d"), label = "ta:Repetitions", 
caption="Number of repetitive Protein Complexes")



###################################################
### chunk number 26: subComp
###################################################
#line 659 "vignette.Rnw"

xtable(subCompM, display = c("s","d","d","d","d","d"), label = "ta:subComplexes", 
caption = "Number of Protein Sub-Complexes")



###################################################
### chunk number 27: createDataFrame
###################################################
#line 691 "vignette.Rnw"
goDF = createGODataFrame(go, goM)
mipsDesc <- sapply(mips, function(x) {attr(x, "desc")})
mipsDF = createMipsDataFrame(mipsDesc, mipsM)


###################################################
### chunk number 28: dataFrameOut
###################################################
#line 724 "vignette.Rnw"
#head(mipsDF)


###################################################
### chunk number 29: createYeastDataObj
###################################################
#line 732 "vignette.Rnw"
mipsOb = createYeastDataObj(mipsDF)
goOb = createYeastDataObj(goDF)


###################################################
### chunk number 30: yeastDataMethods
###################################################
#line 740 "vignette.Rnw"
ID(mipsOb, "MIPS-510.40")
Desc(mipsOb, "MIPS-510.40")
getURL(mipsOb, "MIPS-510.40")


###################################################
### chunk number 31: ScISI2html
###################################################
#line 766 "vignette.Rnw"
mipsNames = colnames(mipsM)
mipsCompOrder = colSums(mipsM)
url = vector(length = length(mipsNames))
linkNames = vector(length = length(mipsNames))
for(i in 1:length(mipsNames)){
url[i] = getURL(mipsOb, mipsNames[i])
linkNames[i] = Desc(mipsOb, mipsNames[i])
}
ScISI2html(urlVect = url, linkName = linkNames, filename = "mips.html", 
           title = "MIPS Protein Complex", compSize = mipsCompOrder)

goNames = as.character(goDF[,1])
goCompOrder = colSums(goM[,goNames])
url = vector(length = length(goNames))
linkNames = vector(length = length(goNames))
for(i in 1:length(goNames)){
    print(i)
    url[i] = getURL(goOb, goNames[i])
    linkNames[i] = Desc(goOb, goNames[i])
}
ScISI2html(urlVect = url, linkName = linkNames, filename = "go.html", 
           title = "GO Protein Complex", compSize = goCompOrder)


###################################################
### chunk number 32: unWantedComp
###################################################
#line 810 "vignette.Rnw"

#ISI2 = unWantedComp(ISI, unwantedComplex =
#                         c("GO:0000262",
#                           "GO:0000228",
#                           "GO:0000775",
#                           "GO:0010008",
#                           "GO:0005792",
#                           "GO:0005768",
#                           "GO:0005769",
#                           "GO:0005770",
#                           "GO:0005777",
#                           "GO:0005844",
#                           "GO:0001400"))

data(ScISIC)
identical(ISI, ScISIC)



###################################################
### chunk number 33: checking
###################################################
#line 835 "vignette.Rnw"


