###################################################
### chunk number 1: f_example
###################################################
#line 79 "Clustering_by_SamSPECTRAL.Rnw"
    library(SamSPECTRAL)
    data(small_data)
	full <- small
	
    L <- SamSPECTRAL(full,dimension=c(1,2,3),normal.sigma = 200,separation.factor = 0.39)   
	plot(full, pch='.', col= L)


###################################################
### chunk number 2: ReadFiles2
###################################################
#line 101 "Clustering_by_SamSPECTRAL.Rnw"

    data(small_data)
	full <- small


###################################################
### chunk number 3: ReadFiles2
###################################################
#line 110 "Clustering_by_SamSPECTRAL.Rnw"
	run.live <- FALSE


###################################################
### chunk number 4: ReadFiles2
###################################################
#line 119 "Clustering_by_SamSPECTRAL.Rnw"
	# Parameters:
    m <- 3000; 
    community.weakness.threshold <-1; precision <- 6; 
	maximum.number.of.clusters <- 30    


###################################################
### chunk number 5: ReadFiles2
###################################################
#line 127 "Clustering_by_SamSPECTRAL.Rnw"
	for (i.column in 1:dim(full)[2]){#For all columns
		ith.column <- full[,i.column]
		full[,i.column] <- (ith.column-min(ith.column)) /(max(ith.column) - min(ith.column) )  # This is the scaled column.
	}#End for (i.column.
	# Therefore, 	
	space.length <- 1


###################################################
### chunk number 6: f_sampling
###################################################
#line 137 "Clustering_by_SamSPECTRAL.Rnw"
	# Sample the data and build the communities 
    society <- Building_Communities(full,m, space.length, community.weakness.threshold)
	plot(full[society$representatives, ], pch=20)


###################################################
### chunk number 7: f_small
###################################################
#line 149 "Clustering_by_SamSPECTRAL.Rnw"
	normal.sigma <- 10
    # Compute conductance between communities
    conductance <- Conductance_Calculation(full, normal.sigma, space.length, society, precision)
    # Compute the eigenspace:
    if (run.live){
	    clust_result.10 <- Civilized_Spectral_Clustering(full, maximum.number.of.clusters, society, conductance,stabilizer=1)    
		eigen.values.10 <- clust_result.10@eigen.space$values
	} else 
		data("eigen.values.10")		
 	plot(eigen.values.10[1:50])


###################################################
### chunk number 8: f_large
###################################################
#line 166 "Clustering_by_SamSPECTRAL.Rnw"
	normal.sigma <- 1000
    # Compute conductance between communities
    conductance <- Conductance_Calculation(full, normal.sigma, space.length, society, precision)
    # Compute the eigenspace:
    if (run.live){
	    clust_result.1000 <- Civilized_Spectral_Clustering(full, maximum.number.of.clusters, society, conductance,stabilizer=1)    
		eigen.values.1000 <- clust_result.1000@eigen.space$values
	} else 
		data("eigen.values.1000")		
 	plot(eigen.values.1000[1:50])


###################################################
### chunk number 9: f_appropriate
###################################################
#line 181 "Clustering_by_SamSPECTRAL.Rnw"
	normal.sigma <- 250
    # Compute conductance between communities
    conductance <- Conductance_Calculation(full, normal.sigma, space.length, society, precision)
    # Compute the eigenspace:
    clust_result.250 <- Civilized_Spectral_Clustering(full, maximum.number.of.clusters, society, conductance,stabilizer=1)    
	eigen.values.250 <- clust_result.250@eigen.space$values
 	plot(eigen.values.250[1:50])


###################################################
### chunk number 10: f_sep1
###################################################
#line 194 "Clustering_by_SamSPECTRAL.Rnw"
	# Extracting labels:
    labels.for_num.of.clusters <- clust_result.250@labels.for_num.of.clusters
	number.of.clusters <- clust_result.250@number.of.clusters
    L33 <- labels.for_num.of.clusters[[number.of.clusters]]
	# Setting septation factor:
	separation.factor <- 0.1
	# post-processing:
    component.of <- Connecting(full, society, conductance, number.of.clusters, labels.for_num.of.clusters, separation.factor)$label
	# ploting:
    plot(full, pch='.', col= component.of)


###################################################
### chunk number 11: f_sep2
###################################################
#line 208 "Clustering_by_SamSPECTRAL.Rnw"
	# Setting septation factor:
	separation.factor <- 0.5
	# post-possesing:
    component.of <- Connecting(full, society, conductance, number.of.clusters, labels.for_num.of.clusters, separation.factor)$label
	# ploting:
    plot(full, pch='.', col= component.of) 


