###################################################
### chunk number 1: source package
###################################################
#line 73 "SQUADD.Rnw"
library(SQUADD)


###################################################
### chunk number 2: instance
###################################################
#line 86 "SQUADD.Rnw"
# construct instance of SquadSimResServiceImpl
fpath <- system.file("extdata", package="SQUADD")
folder <- file.path(fpath,"data_IAA")
sim <- simResService (folder=folder,
			  time= 45,
			  ncolor=5,
      		  legend= c("ARF(a)", "ARF(i)", "AR_Genes", "Aux/IAA", 
      		  "BES1/BZR1","BIN2","BR","BRI1BAK1","BRR_Genes","BRX","BR_Biosynthesis","BZR1","DO","IAA","IAA_Biosynthesis","NGA1", "PIN", "SCFTir1","StimAux", "StimBR"), indexDeno=1,
			  method="lowess")


###################################################
### chunk number 3: SimMatrix
###################################################
#line 108 "SQUADD.Rnw"
sim["selectNode"] <-c("DO","IAA_Biosynthesis","BR_Biosynthesis", "IAA", "BR")
plotSimMatrix(sim)


###################################################
### chunk number 4: fittedValues
###################################################
#line 131 "SQUADD.Rnw"
tab <- getFittedTable(sim)


###################################################
### chunk number 5: PredMap
###################################################
#line 154 "SQUADD.Rnw"
plotPredMap(sim)


###################################################
### chunk number 6: FigPredMap
###################################################
#line 161 "SQUADD.Rnw"
#line 154 "SQUADD.Rnw"
plotPredMap(sim)
#line 162 "SQUADD.Rnw"


###################################################
### chunk number 7: CorrelationCircle
###################################################
#line 179 "SQUADD.Rnw"
# Fill the field conditionList of the object sim 
sim["conditionList"] <- c("Normal", "brxlof", "BRrescue","brxarfilof","brxarfiBRrescue", "brxgof") 
plotCC(sim)


###################################################
### chunk number 8: figCorrCircle
###################################################
#line 187 "SQUADD.Rnw"
#line 179 "SQUADD.Rnw"
# Fill the field conditionList of the object sim 
sim["conditionList"] <- c("Normal", "brxlof", "BRrescue","brxarfilof","brxarfiBRrescue", "brxgof") 
plotCC(sim)
#line 188 "SQUADD.Rnw"


###################################################
### chunk number 9: 
###################################################
#line 214 "SQUADD.Rnw"
sessionInfo()


