###################################################
### chunk number 1: set up
###################################################
#line 79 "SLGI.Rnw"
library("SLGI")
library("org.Sc.sgd.db")

##loading Tong et al data
data(SGA)
data(Atong)


###################################################
### chunk number 2: rejected
###################################################
#line 99 "SLGI.Rnw"
rejected <- length(intersect(SGA, org.Sc.sgdREJECTORF))


###################################################
### chunk number 3: aliasMatch
###################################################
#line 110 "SLGI.Rnw"
updateSGA=mget(SGA, org.Sc.sgdCOMMON2ORF, ifnotfound = NA )


###################################################
### chunk number 4: essential genes in query gene list
###################################################
#line 122 "SLGI.Rnw"
data(essglist)
esg = names(essglist)
n1 <- sum( esg %in% dimnames(Atong)[[1]])
n2 <- sum( esg %in% dimnames(Atong)[[2]])


###################################################
### chunk number 5: 
###################################################
#line 155 "SLGI.Rnw"
data(Boeke2006raw)
data(Boeke2006)


###################################################
### chunk number 6: 
###################################################
#line 180 "SLGI.Rnw"
## Schuldiner et al. (2005)
data(gi2005)
data(gi2005.metadata)


###################################################
### chunk number 7: 
###################################################
#line 201 "SLGI.Rnw"
data(TFmat)


###################################################
### chunk number 8: ScISI
###################################################
#line 221 "SLGI.Rnw"
library(ScISI)
data(ScISIC)
ScISIC[1:5, 1:5]


###################################################
### chunk number 9: 
###################################################
#line 231 "SLGI.Rnw"
data(Boeke2006)
data(dSLAM)

dim(Boeke2006)
Boeke2006red <- gi2Interactome(Boeke2006, ScISIC)
dim(Boeke2006red)


###################################################
### chunk number 10: 
###################################################
#line 247 "SLGI.Rnw"
interact <- getInteraction(Boeke2006red, dSLAM, ScISIC)


###################################################
### chunk number 11: 
###################################################
#line 253 "SLGI.Rnw"
intSummary <- iSummary(interact$bwMat, n=5)


###################################################
### chunk number 12:  eval=FALSE
###################################################
## #line 262 "SLGI.Rnw"
## modelBoeke <- modelSLGI(Boeke2006red, 
##           universe= dSLAM, interactome=ScISIC,type="intM", perm=5)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## #line 271 "SLGI.Rnw"
## plot(modelBoeke,pch=20)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## #line 292 "SLGI.Rnw"
## array <- dSLAM[dSLAM %in% rownames(ScISIC)]
## query <- rownames(Boeke2006)[rownames(Boeke2006) %in% rownames(ScISIC)]
## allInteract <- matrix(1, nrow=length(query), ncol=length(array),
##                dimnames=list(query, array))
## tested <- getInteraction(allInteract, dSLAM, ScISIC)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## #line 300 "SLGI.Rnw"
## testedInteract <- test2Interact(iMat=interact$bwMat, tMat=tested$bwMat, interactome=ScISIC)
## significant <- hyperG(cbind("Tested"=testedInteract$tested,"Interact"=testedInteract$interact), 
##               sum(Boeke),  nrow(Boeke2006red)*length(dSLAM)) 


