###################################################
### chunk number 1: read
###################################################
#line 20 "quick-start.Rnw"
library(SBMLR)
curto=readSBML(system.file("models", "curto.xml", package = "SBMLR"))  
head(summary(curto)$reactions)


###################################################
### chunk number 2: save
###################################################
#line 30 "quick-start.Rnw"
saveSBML(curto,"curto.xml")
saveSBMLR(curto,"curto.r")


###################################################
### chunk number 3: equality
###################################################
#line 35 "quick-start.Rnw"
curtoX=readSBML("curto.xml")
curtoR=readSBMLR("curto.r")
head((curtoX==curtoR)$species)
head((curtoX==curtoR)$reactions)


###################################################
### chunk number 4: simulation
###################################################
#line 47 "quick-start.Rnw"
out1=simulate(curto,seq(-20,0,1))
curto$species$PRPP$ic=50
out2=simulate(curto,0:70)
outs=data.frame(rbind(out1,out2))
attach(outs) 
par(mfrow=c(2,1))
plot(time,IMP,type="l",xlab="minutes",ylab="IMP (uM)")
plot(time,HX,type="l",xlab="minutes",ylab="HX (uM)")
par(mfrow=c(1,1))
detach(outs)


###################################################
### chunk number 5: bumpLessXfer
###################################################
#line 68 "quick-start.Rnw"
curto$species$PRPP$ic=5  # return PRPP IC to its original value
simulate(curto,(-10):10,modulator=rep(2,37)) # bumpless transfer in concentrations since all V increase by 2


###################################################
### chunk number 6: unstable
###################################################
#line 74 "quick-start.Rnw"
simulate(curto,(-10):10,modulator=c(rep(1.1,20),rep(0.9,17))) # half up, half down, not bumpless


###################################################
### chunk number 7: folateSim
###################################################
#line 80 "quick-start.Rnw"
morr=readSBML(file.path(system.file(package="SBMLR"), "models/morrison.xml"))  
out1=simulate(morr,seq(-20,0,1))
morr$species$EMTX$ic=1 # bolus of methotrexate to 1 uM
out2=simulate(morr,0:30)
outs=data.frame(rbind(out1,out2))
attach(outs)
par(mfrow=c(3,4))
plot(time,FH2b,type="l",xlab="Hours")
plot(time,FH2f,type="l",xlab="Hours")
plot(time,DHFRf,type="l",xlab="Hours")
plot(time,DHFRtot,type="l",xlab="Hours")
plot(time,CHOFH4,type="l",xlab="Hours")
plot(time,FH4,type="l",xlab="Hours")
plot(time,CH2FH4,type="l",xlab="Hours")
plot(time,CH3FH4,type="l",xlab="Hours")
plot(time,AICARsyn,type="l",xlab="Hours")
plot(time,MTR,type="l",xlab="Hours")
plot(time,TYMS,type="l",xlab="Hours")
#plot(time,EMTX,type="l",xlab="Hours")
plot(time,DHFReductase,type="l",xlab="Hours")
par(mfrow=c(1,1))
detach(outs)


###################################################
### chunk number 8: summaryDump
###################################################
#line 107 "quick-start.Rnw"
summary(curto)
curto


