###################################################
### chunk number 1: 
###################################################
#line 34 "Rtreemix.Rnw"
options(width = 70)


###################################################
### chunk number 2: 
###################################################
#line 77 "Rtreemix.Rnw"
library(Rtreemix)


###################################################
### chunk number 3: 
###################################################
#line 88 "Rtreemix.Rnw"
data(hiv.data)
show(hiv.data) ## show the RtreemixData object


###################################################
### chunk number 4: 
###################################################
#line 95 "Rtreemix.Rnw"
ex.data <- new("RtreemixData", File = paste(.path.package(package = "Rtreemix"), "/examples/treemix.pat", sep = ""))
show(ex.data) ## show the RtreemixData object


###################################################
### chunk number 5: 
###################################################
#line 100 "Rtreemix.Rnw"
bin.mat <- cbind(c(1, 0, 0, 1, 1), c(0, 1, 0, 0, 1), c(1, 1, 0, 1, 0))
toy.data <- new("RtreemixData", Sample = bin.mat)
show(toy.data)


###################################################
### chunk number 6: 
###################################################
#line 106 "Rtreemix.Rnw"
Sample(hiv.data)
Events(hiv.data)
Patients(hiv.data)
eventsNum(hiv.data)
sampleSize(hiv.data)


###################################################
### chunk number 7: 
###################################################
#line 117 "Rtreemix.Rnw"
mod <- fit(data = hiv.data, K = 2, equal.edgeweights = TRUE, noise = TRUE)
show(mod)


###################################################
### chunk number 8: 
###################################################
#line 125 "Rtreemix.Rnw"
plot(mod, fontSize = 15)


###################################################
### chunk number 9: 
###################################################
#line 133 "Rtreemix.Rnw"
dev.off()
plot(mod, k=2, fontSize = 14)


###################################################
### chunk number 10: 
###################################################
#line 139 "Rtreemix.Rnw"
Weights(mod)
Trees(mod)
getTree(object = mod, k = 2) ## Get a specific tree component k
edgeData(getTree(object = mod, k = 2), attr = "weight") ## Conditional probabilities assigned to edges of the 2nd tree component
numTrees(mod)
getData(mod)


###################################################
### chunk number 11: 
###################################################
#line 148 "Rtreemix.Rnw"
Star(mod)
Resp(mod)
CompleteMat(mod)


###################################################
### chunk number 12: 
###################################################
#line 154 "Rtreemix.Rnw"
distr <- distribution(model = mod)
distr$probability


###################################################
### chunk number 13: 
###################################################
#line 159 "Rtreemix.Rnw"
rand.mod <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
show(rand.mod)


###################################################
### chunk number 14: 
###################################################
#line 172 "Rtreemix.Rnw"
mod.stat <- likelihoods(model = mod, data = hiv.data)
Model(mod.stat)
getData(mod.stat)
LogLikelihoods(mod.stat)
WLikelihoods(mod.stat)


###################################################
### chunk number 15: 
###################################################
#line 181 "Rtreemix.Rnw"
getResp(mod.stat)


###################################################
### chunk number 16: 
###################################################
#line 188 "Rtreemix.Rnw"
data <- sim(model = rand.mod, no.draws = 300)
show(data)


