###################################################
### chunk number 1: 
###################################################
#line 45 "RBGL.Rnw"
library(RBGL)
library(Rgraphviz)
library(XML)


###################################################
### chunk number 2: bfDemo
###################################################
#line 97 "RBGL.Rnw"
con <- file(system.file("XML/bfsex.gxl", package="RBGL"))
bf <- fromGXL(con)
close(con)


###################################################
### chunk number 3: figbf
###################################################
#line 103 "RBGL.Rnw"
  plot(bf, main="a) Breath-First Search Example")


###################################################
### chunk number 4: dfDemo
###################################################
#line 107 "RBGL.Rnw"
con <- file(system.file("XML/dfsex.gxl", package="RBGL"))
df <- fromGXL(con)
close(con)


###################################################
### chunk number 5: figdf
###################################################
#line 113 "RBGL.Rnw"
  plot(df, main="b) Depth-First Search Example")


###################################################
### chunk number 6: dijkstraDemo
###################################################
#line 117 "RBGL.Rnw"
con <- file(system.file("XML/dijkex.gxl", package="RBGL"))
dijk <- fromGXL(con)
close(con)


###################################################
### chunk number 7: figdijk
###################################################
#line 123 "RBGL.Rnw"
 plot(dijk, main="c) Dijkstra's Example")


###################################################
### chunk number 8: connDemo
###################################################
#line 127 "RBGL.Rnw"
con <- file(system.file("XML/conn.gxl", package="RBGL"))
coex <- fromGXL(con)
close(con)


###################################################
### chunk number 9: figcoex
###################################################
#line 133 "RBGL.Rnw"
 plot(coex, main="d) Coex Example")


###################################################
### chunk number 10: conn2Demo
###################################################
#line 137 "RBGL.Rnw"
con <- file(system.file("XML/conn2.gxl", package="RBGL"))
coex2 <- fromGXL(con)
close(con)


###################################################
### chunk number 11: figcoex2
###################################################
#line 143 "RBGL.Rnw"
  plot(coex2, main="e) Coex2 Example")


###################################################
### chunk number 12: conn2iDemo
###################################################
#line 147 "RBGL.Rnw"
con <- file(system.file("XML/conn2iso.gxl", package="RBGL"))
coex2i <- fromGXL(con)
close(con)


###################################################
### chunk number 13: figcoex2i
###################################################
#line 153 "RBGL.Rnw"
  plot(coex2i, main="f) Coex2 Isomorphism Example")


###################################################
### chunk number 14: kmstDemo
###################################################
#line 157 "RBGL.Rnw"
con <- file(system.file("XML/kmstEx.gxl", package="RBGL"))
km <- fromGXL(con)
close(con)


###################################################
### chunk number 15: figkmst
###################################################
#line 163 "RBGL.Rnw"
  plot(km, main="g) Kruskal MST Example")


###################################################
### chunk number 16: bicoDemo
###################################################
#line 167 "RBGL.Rnw"
con <- file(system.file("XML/biconn.gxl", package="RBGL"))
bicoex <- fromGXL(con)
close(con)


###################################################
### chunk number 17: figbico
###################################################
#line 173 "RBGL.Rnw"
  plot(bicoex, main="h) Biconnected Component Example")


###################################################
### chunk number 18: ospfDemo
###################################################
#line 177 "RBGL.Rnw"
con <- file(system.file("XML/ospf.gxl", package="RBGL"))
ospf <- fromGXL(con)
close(con)


###################################################
### chunk number 19: figospf
###################################################
#line 183 "RBGL.Rnw"
  plot(ospf, main="i) Ospf Example")


###################################################
### chunk number 20: zzDemo
###################################################
#line 187 "RBGL.Rnw"
con <- file(system.file("dot/joh.gxl", package="RBGL"))
joh <- fromGXL(con)
close(con)


###################################################
### chunk number 21: figjoh
###################################################
#line 193 "RBGL.Rnw"
  plot(joh, main="j) joh Example")


###################################################
### chunk number 22: hcsDemo
###################################################
#line 197 "RBGL.Rnw"
con <- file(system.file("XML/hcs.gxl", package="RBGL"))
hcs <- fromGXL(con)
close(con)


###################################################
### chunk number 23: fighcs
###################################################
#line 203 "RBGL.Rnw"
  plot(hcs, main="k) HCS Example")


###################################################
### chunk number 24: kclexDemo
###################################################
#line 207 "RBGL.Rnw"
con <- file(system.file("XML/snacliqueex.gxl", package="RBGL"))
kclex <- fromGXL(con)
close(con)


###################################################
### chunk number 25: figkclex
###################################################
#line 213 "RBGL.Rnw"
  plot(kclex, main="l) kCliques Example")


###################################################
### chunk number 26: kcoexDemo
###################################################
#line 217 "RBGL.Rnw"
con <- file(system.file("XML/snacoreex.gxl", package="RBGL"))
kcoex <- fromGXL(con)
close(con)


###################################################
### chunk number 27: figkcoex
###################################################
#line 223 "RBGL.Rnw"
  plot(kcoex, main="m) kCores Example")


###################################################
### chunk number 28: showFileDep
###################################################
#line 269 "RBGL.Rnw"
data(FileDep)
FileDep


###################################################
### chunk number 29: figfd
###################################################
#line 274 "RBGL.Rnw"
z <- plot(FileDep)


###################################################
### chunk number 30: DFSdemo
###################################################
#line 290 "RBGL.Rnw"
print(dfs.res <- dfs(df, "y"))


###################################################
### chunk number 31: figdfs1
###################################################
#line 299 "RBGL.Rnw"
plot(df, main="a) DFS Example")


###################################################
### chunk number 32: figdfs2
###################################################
#line 303 "RBGL.Rnw"
dfsNattrs <- makeNodeAttrs(df)
dfsNattrs$label[dfs.res$discovered] <- 1:numNodes(df)
plot(df, nodeAttrs=dfsNattrs, main="b) DFS Example with search order")


###################################################
### chunk number 33: BFSdemo
###################################################
#line 326 "RBGL.Rnw"
print(bfs.res <- bfs(bf,"s"))


###################################################
### chunk number 34: figbfs1
###################################################
#line 337 "RBGL.Rnw"
plot(bf, main="a) BFS Example")


###################################################
### chunk number 35: figbfs2
###################################################
#line 341 "RBGL.Rnw"
bfsNattrs <- makeNodeAttrs(bf)
bfsNattrs$label[bfs.res] <- 1:numNodes(bf)
plot(bf, nodeAttrs=bfsNattrs, main="b) BFS Example with search order")


###################################################
### chunk number 36: dijkdemo1
###################################################
#line 406 "RBGL.Rnw"
nodes(dijk)
edgeWeights(dijk)
dijkstra.sp(dijk)


###################################################
### chunk number 37: dijkdemo2
###################################################
#line 428 "RBGL.Rnw"
nodes(ospf)[6]
dijkstra.sp(ospf,nodes(ospf)[6])
sp.between(ospf, "RT6", "RT1")


###################################################
### chunk number 38: figospf
###################################################
#line 440 "RBGL.Rnw"
z <- plot(ospf)


###################################################
### chunk number 39: bellmanfordDemo
###################################################
#line 451 "RBGL.Rnw"
dd <- coex2
nodes(dd)
bellman.ford.sp(dd)
bellman.ford.sp(dd,nodes(dd)[2])


###################################################
### chunk number 40: DAGDemo
###################################################
#line 470 "RBGL.Rnw"
dd <- coex2
dag.sp(dd)
dag.sp(dd,nodes(dd)[2])


###################################################
### chunk number 41: johnsonDemo
###################################################
#line 486 "RBGL.Rnw"
zz <- joh
edgeWeights(zz)
johnson.all.pairs.sp(zz)


###################################################
### chunk number 42: figjoh
###################################################
#line 492 "RBGL.Rnw"
z <- plot(zz)


###################################################
### chunk number 43: floydwarshallDemo
###################################################
#line 511 "RBGL.Rnw"
floyd.warshall.all.pairs.sp(coex)


###################################################
### chunk number 44: KMSTdemo
###################################################
#line 531 "RBGL.Rnw"
mstree.kruskal(km)


###################################################
### chunk number 45: primDemo
###################################################
#line 540 "RBGL.Rnw"
mstree.prim(coex2)


###################################################
### chunk number 46: conndemo
###################################################
#line 559 "RBGL.Rnw"
km1 <- km
km1 <- graph::addNode(c("F","G","H"), km1)
km1 <- addEdge("G", "H", km1, 1)
km1 <- addEdge("H", "G", km1, 1)
connectedComp(ugraph(km1))


###################################################
### chunk number 47: figkm1
###################################################
#line 567 "RBGL.Rnw"
plot(km1, main="Modified Kruskal MST example")


###################################################
### chunk number 48: sconndemo
###################################################
#line 594 "RBGL.Rnw"
km2 <- km
km2 <- graph::addNode(c("F","G","H"), km2)
km2 <- addEdge("G", "H", km2, 1)
km2 <- addEdge("H", "G", km2, 1)
strongComp(km2)


###################################################
### chunk number 49: biConnCompdemo
###################################################
#line 615 "RBGL.Rnw"
biConnComp(bicoex)
articulationPoints(bicoex)


###################################################
### chunk number 50: figbicoex
###################################################
#line 621 "RBGL.Rnw"
z <- plot(bicoex)


###################################################
### chunk number 51: incrCompdemo
###################################################
#line 648 "RBGL.Rnw"
jcoex <- join(coex, hcs)
x <- init.incremental.components(jcoex)
incremental.components(jcoex)
same.component(jcoex, "A", "F")
same.component(jcoex, "A", "A1")
jcoex <- addEdge("A", "A1", jcoex)
x <- init.incremental.components(jcoex)
incremental.components(jcoex)
same.component(jcoex, "A", "A1")


###################################################
### chunk number 52: figjcoex
###################################################
#line 661 "RBGL.Rnw"
z <- plot(jcoex)


###################################################
### chunk number 53: MaxFlowdemo
###################################################
#line 685 "RBGL.Rnw"
edgeWeights(dijk)
edmonds.karp.max.flow(dijk, "B", "D")
push.relabel.max.flow(dijk, "C", "B")


###################################################
### chunk number 54: SparseMatrixOrderingdemo
###################################################
#line 719 "RBGL.Rnw"
dijk1 <- ugraph(dijk)
cuthill.mckee.ordering(dijk1)
minDegreeOrdering(dijk1)
sloan.ordering(dijk1)


###################################################
### chunk number 55: edgeConndemo
###################################################
#line 744 "RBGL.Rnw"
edgeConnectivity(coex)


###################################################
### chunk number 56: tsortDemo1
###################################################
#line 757 "RBGL.Rnw"
tsort(FileDep)


###################################################
### chunk number 57: tsortDemo2
###################################################
#line 765 "RBGL.Rnw"
FD2 <- FileDep
# now introduce a cycle
FD2 <- addEdge(from="bar_o", to="dax_h", FD2)
tsort(FD2)


###################################################
### chunk number 58: Layoutdemo
###################################################
#line 784 "RBGL.Rnw"
# library(Rgraphviz)
plot(coex, "neato")


###################################################
### chunk number 59: figneato
###################################################
#line 788 "RBGL.Rnw"
z <- plot(coex, "neato")


###################################################
### chunk number 60: Layoutdemo2
###################################################
#line 816 "RBGL.Rnw"
randomGraphLayout(coex)
circleLayout(coex)
kamadaKawaiSpringLayout(coex)
fruchtermanReingoldForceDirectedLayout(coex, 10, 10)


###################################################
### chunk number 61: Layoutdemo3
###################################################
#line 828 "RBGL.Rnw"
crudeGraphPlot <- function(g, alg=circleLayout, ...) {
#
# the alg parameter is a function that computes the
# layout of g, returning it as a list of length 1
# with two rows: top row is x coordinates, bottom is
# y coordinates, and node names are used as colnames
# the ... are passed to segments()
#
  layout <- alg(g)
  plot( layout[1,], layout[2,], pch=nodes(g), axes=FALSE,
    xlab="", ylab="", main=substitute(g), cex=1.4 )
  ee <- edges(g)
  src <- names(ee)
  ds <- function(nn1, nn2, lob) segments(lob[1,nn1], lob[2,nn1],
        lob[1,nn2], lob[2,nn2], ...)
  for (s in src) sapply(ee[[s]], function(x) ds(s, x, layout))
  invisible(NULL)
}

crudeGraphPlot(coex)
crudeGraphPlot(coex, alg=kamadaKawaiSpringLayout, col="green")


###################################################
### chunk number 62: figlayout1
###################################################
#line 852 "RBGL.Rnw"
crudeGraphPlot(coex)


###################################################
### chunk number 63: figlayout2
###################################################
#line 856 "RBGL.Rnw"
crudeGraphPlot(coex, alg=kamadaKawaiSpringLayout, col="green")


###################################################
### chunk number 64: Isomorphismdemo
###################################################
#line 886 "RBGL.Rnw"
isomorphism(dijk, coex2)
isomorphism(coex2i, coex2)


###################################################
### chunk number 65: figcoex2i
###################################################
#line 891 "RBGL.Rnw"
z <- plot(coex2i)


###################################################
### chunk number 66: VertexColoringdemo
###################################################
#line 912 "RBGL.Rnw"
sequential.vertex.coloring(coex)


###################################################
### chunk number 67: transClosuredemo
###################################################
#line 955 "RBGL.Rnw"
dijk.tc = transitive.closure(dijk)


###################################################
### chunk number 68: figdijkTC
###################################################
#line 959 "RBGL.Rnw"
  plot(dijk.tc, main="b) Transitive closure")


###################################################
### chunk number 69: wavefrontdemo
###################################################
#line 986 "RBGL.Rnw"
ss <- 1
ith.wavefront(dijk, ss)
maxWavefront(dijk)
aver.wavefront(dijk)
rms.wavefront(dijk)


###################################################
### chunk number 70: Centralitydemo
###################################################
#line 1014 "RBGL.Rnw"
brandes.betweenness.centrality(coex)
betweenness.centrality.clustering(coex, 0.1, TRUE)


###################################################
### chunk number 71: mincutdemo
###################################################
#line 1034 "RBGL.Rnw"
minCut(coex)


###################################################
### chunk number 72: highlyConnSGdemo
###################################################
#line 1051 "RBGL.Rnw"
highlyConnSG(coex)
highlyConnSG(hcs)


###################################################
### chunk number 73: MaxCliquedemo
###################################################
#line 1078 "RBGL.Rnw"
maxClique(coex)
maxClique(hcs)


###################################################
### chunk number 74: IsTriangulateddemo
###################################################
#line 1101 "RBGL.Rnw"
is.triangulated(coex)
is.triangulated(hcs)


###################################################
### chunk number 75: Separatesdemo
###################################################
#line 1111 "RBGL.Rnw"
separates("B", "A", "E", km)
separates("B", "A", "C", km)


###################################################
### chunk number 76: kCoresdemo1
###################################################
#line 1129 "RBGL.Rnw"
kCores(kcoex)
kcoex2 <- coex2
kCores(kcoex2)
kCores(kcoex2, "in")
kCores(kcoex2, "out")
g1 <- addEdge("C", "B", kcoex2)
kCores(g1, "in")
g2 <- addEdge("C", "A", kcoex2)
kCores(g2, "out")


###################################################
### chunk number 77: figkcores
###################################################
#line 1141 "RBGL.Rnw"
z <- plot(kcoex)


###################################################
### chunk number 78: kCliquesdemo
###################################################
#line 1184 "RBGL.Rnw"
kCliques(kclex)


###################################################
### chunk number 79: figkcliques
###################################################
#line 1188 "RBGL.Rnw"
z <- plot(kclex)


