###################################################
### chunk number 1: loadPackageData
###################################################
#line 99 "PatientGeneSets.Rnw"
library(PatientGeneSets)
data(Parsons)
ls()

library(KEGG.db)
KEGGPATHID2EXTID


###################################################
### chunk number 2: loadID2name
###################################################
#line 113 "PatientGeneSets.Rnw"
data(ID2name)
head(ID2name)


###################################################
### chunk number 3: calcBrainResults
###################################################
#line 137 "PatientGeneSets.Rnw"
as.character(KEGGPATHNAME2ID[c("Endometrial cancer", 
                               "Non-small cell lung cancer",
                               "Alanine, aspartate and glutamate metabolism")])

resultsBrain <-
    do.gene.set.analysis(EventsBySample = EventsBySampleBrain,
                         GeneSizes = GeneSizes08,
                         GeneSets = KEGGPATHID2EXTID[c("hsa05213", 
                         "hsa05223",  "hsa00250")],
                         Coverage = CoverageBrain,
                         ID2name = ID2name,
                         gene.method = FALSE,
                         perm.null.method = TRUE,
                         perm.null.het.method = FALSE,
                         pass.null.method = TRUE,
                         pass.null.het.method = FALSE)


###################################################
### chunk number 4: showBrainResults
###################################################
#line 159 "PatientGeneSets.Rnw"
resultsBrain


###################################################
### chunk number 5: calcGeneScores
###################################################
#line 170 "PatientGeneSets.Rnw"
GeneScores <- cma.scores(cma.data = MutationsBrain,
                         number.genes = nrow(GeneSizes08))

head(GeneScores)


###################################################
### chunk number 6: simData
###################################################
#line 199 "PatientGeneSets.Rnw"
set.seed(831984)

resultsSim <- 
    sim.data.p.values(EventsBySample = EventsBySampleBrain,
                      Mutations = MutationsBrain,
                      GeneSizes = GeneSizes08,
                      Coverage = CoverageBrain,
		      GeneSets = KEGGPATHID2EXTID[c("hsa05213", 
                      "hsa05223", "hsa00250")],
		      ID2name = ID2name,
                      nr.iter = 2,
                      pass.null = TRUE,
                      perc.samples = c(75, 95),
                      spiked.set.sizes = c(50),
                      show.iter = TRUE,
                      gene.method = FALSE,
                      perm.null.method = TRUE,
                      perm.null.het.method = FALSE,
                      pass.null.method = TRUE,
                      pass.null.het.method = FALSE)

resultsSim

slotNames(resultsSim)

resultsSim@null.dist


###################################################
### chunk number 7: extractSimMethod
###################################################
#line 238 "PatientGeneSets.Rnw"
extract.sims.method(resultsSim,
                    "p.values.perm.null")



###################################################
### chunk number 8: combineSims
###################################################
#line 246 "PatientGeneSets.Rnw"
combine.sims(resultsSim, resultsSim)


