###################################################
### chunk number 1: bslnoffSingle
###################################################
#line 52 "howtoprocess.Rnw"
library(PROcess)
fdat <- system.file("Test", package="PROcess")
fs <- list.files(fdat, pattern="\\.*csv\\.*", full.names=TRUE)
f1 <- read.files(fs[1])
fcut <- f1[f1[,1]>0,]
bseoff <-bslnoff(fcut,method="loess",plot=TRUE, bw=0.1)
title(basename(fs[1]))


###################################################
### chunk number 2: isPeakSingle
###################################################
#line 73 "howtoprocess.Rnw"
pkgobj <- isPeak(bseoff,span=81,sm.span=11,plot=TRUE)


###################################################
### chunk number 3: specZoom
###################################################
#line 79 "howtoprocess.Rnw"
specZoom(pkgobj, xlim=c(5000,10000))


###################################################
### chunk number 4: rmBaselineBatch
###################################################
#line 87 "howtoprocess.Rnw"
testdir <- system.file("Test", package = "PROcess")
testM <- rmBaseline(testdir)


###################################################
### chunk number 5: renorm
###################################################
#line 97 "howtoprocess.Rnw"
rtM <- renorm(testM, cutoff=1500)


###################################################
### chunk number 6: getPeaksBatch
###################################################
#line 102 "howtoprocess.Rnw"
peakfile <- paste(tempdir(), "testpeakinfo.csv", sep = "/")
getPeaks(rtM, peakfile)


###################################################
### chunk number 7: QC
###################################################
#line 112 "howtoprocess.Rnw"
qualRes <- quality(testM, peakfile, cutoff=1500)
print(qualRes)


###################################################
### chunk number 8: pk2bmkr
###################################################
#line 151 "howtoprocess.Rnw"
bmkfile <- paste(tempdir(), "testbiomarker.csv", sep = "/")
testBio <- pk2bmkr(peakfile, rtM, bmkfile)
mzs <- as.numeric(rownames(rtM))
matplot(mzs, rtM, type = "l", xlim = c(1000, 10000),
ylab="intensities", main="proto-biomarkers")
bks <- getMzs(testBio)
print(round(bks))
abline(v = bks, col = "green")


###################################################
### chunk number 9: overallMean
###################################################
#line 200 "howtoprocess.Rnw"
grandAve <- aveSpec(fs)
mzs <- grandAve[,1]


###################################################
### chunk number 10: bslnoffRawMean
###################################################
#line 214 "howtoprocess.Rnw"
grandOff <- bslnoff(grandAve[mzs>0,], method="loess",
        plot=T, bw=0.1)


###################################################
### chunk number 11: RawMeanPeak
###################################################
#line 218 "howtoprocess.Rnw"
grandPkg <- isPeak(grandOff[grandOff[,1]>1500,], zerothrsh=1,
plot=T, ratio=0.1)
grandpvec <- round(grandPkg[grandPkg$peak, "mz"])
print(as.vector(grandpvec))


###################################################
### chunk number 12: getPeaks2
###################################################
#line 226 "howtoprocess.Rnw"
grandBmk <- getPeaks2(rtM, grandpvec)


