###################################################
### chunk number 1: options
###################################################
#line 21 "PROMISE.Rnw"
options(width=60)


###################################################
### chunk number 2: Load PROMISE package and data
###################################################
#line 42 "PROMISE.Rnw"
library(PROMISE)
data(sampExprSet)
data(sampGeneSet)
data(phPatt)


###################################################
### chunk number 3: Extract ArrayData and Endpoint Data from sampExprSet
###################################################
#line 54 "PROMISE.Rnw"
arrayData<-exprs(sampExprSet)
ptData<- pData(phenoData(sampExprSet))
head(arrayData[, 1:4])
head(ptData)
all(colnames(arrayData)==rownames(ptData))


###################################################
### chunk number 4: Extract sampGeneSet to a data frame
###################################################
#line 63 "PROMISE.Rnw"
GS.data<-NULL
for (i in 1:length(sampGeneSet)){
    tt<-sampGeneSet[i][[1]]
    this.name<-unlist(geneIds(tt))
    this.set<-setName(tt)
    this.data<- cbind.data.frame(featureID=as.character(this.name),
             setID=rep(as.character(this.set), length(this.name)))
    GS.data<-rbind.data.frame(GS.data, this.data)
}
sum(!is.element(GS.data[,1], rownames(arrayData)))==0


###################################################
### chunk number 5: Display phPatt
###################################################
#line 80 "PROMISE.Rnw"
phPatt


###################################################
### chunk number 6: PROMISE without GSEA
###################################################
#line 90 "PROMISE.Rnw"
test1<-PROMISE(exprSet=sampExprSet,
             geneSet=NULL, 
             promise.pattern=phPatt, 
             strat.var=NULL, 
             seed=13, 
             nperms=100)


###################################################
### chunk number 7: Gene Level Result
###################################################
#line 99 "PROMISE.Rnw"
gene.res<-test1$generes
head(gene.res)


###################################################
### chunk number 8: Gene Set Result
###################################################
#line 104 "PROMISE.Rnw"
set.res<-test1$setres
head(set.res)


###################################################
### chunk number 9: PROMISE with GSEA
###################################################
#line 110 "PROMISE.Rnw"
test2<-PROMISE(exprSet=sampExprSet,
             geneSet=sampGeneSet,
             promise.pattern=phPatt,
             strat.var=NULL,
             seed=13,
             nperms=100)


###################################################
### chunk number 10: Gene Level Result
###################################################
#line 119 "PROMISE.Rnw"
gene.res2<-test2$generes
head(gene.res2)


###################################################
### chunk number 11: Gene Set Result
###################################################
#line 124 "PROMISE.Rnw"
set.res2<-test2$setres
head(set.res2)


