###################################################
### chunk number 1: Loading PICS
###################################################
#line 38 "PICS.Rnw"
library(PICS)
citation(package="PICS")


###################################################
### chunk number 2: Loading PICS
###################################################
#line 77 "PICS.Rnw"
library(PICS)


###################################################
### chunk number 3: Reading the data
###################################################
#line 90 "PICS.Rnw"
path<-system.file("extdata",package="PICS")
#Read the experiment : 
dataIP<-read.table(file.path(path,"Treatment_tags_chr21_sort.bed"),header=TRUE,colClasses=c("factor","integer","integer","factor"))
dataIP<-as(dataIP,"RangedData")
dataIP<-as(dataIP,"GenomeData")

dataCont<-read.table(file.path(path,"Input_tags_chr21_sort.bed"),header=TRUE,colClasses=c("factor","integer","integer","factor"))
dataCont<-as(dataCont,"RangedData")
dataCont<-as(dataCont,"GenomeData")


###################################################
### chunk number 4: Reading the mappability profile
###################################################
#line 102 "PICS.Rnw"
map<-read.table(file.path(path,"mapProfileShort"),header=TRUE,colClasses=c("factor","integer","integer","NULL"))
map<-as(map,"RangedData")
## Remove the chrM
map<-map[-23]


###################################################
### chunk number 5: Cluster initialization
###################################################
#line 117 "PICS.Rnw"
library(snowfall)
sfInit(parallel=TRUE,cpus=2)
sfLibrary(PICS)


###################################################
### chunk number 6: Genome segmentation
###################################################
#line 123 "PICS.Rnw"
seg<-segmentReads(dataIP, dataC=dataCont, map=map, minReads=1)


###################################################
### chunk number 7: PICS analysis
###################################################
#line 131 "PICS.Rnw"
pics<-PICS(seg,dataType="TF")


###################################################
### chunk number 8: FDR estimation
###################################################
#line 138 "PICS.Rnw"
segC<-segmentReads(dataCont,dataC=dataIP,map=map,minReads=1)
picsC<-PICS(segC,dataType="TF")
fdr<-picsFDR(pics,picsC,filter=list(delta=c(50,Inf),se=c(0,50),sigmaSqF=c(0,22500),sigmaSqR=c(0,22500)))


###################################################
### chunk number 9: plot-FDR1
###################################################
#line 146 "PICS.Rnw"
plot(pics,picsC,xlim=c(2,8),ylim=c(0,.2),filter=list(delta=c(50,300),se=c(0,50),sigmaSqF=c(0,22500),sigmaSqR=c(0,22500)),type="l")


###################################################
### chunk number 10: plot-FDR2
###################################################
#line 152 "PICS.Rnw"
plot(fdr[,c(3,1)])


###################################################
### chunk number 11: Create RangedData data object of enriched regions
###################################################
#line 162 "PICS.Rnw"
myFilter=list(delta=c(50,300),se=c(0,50),sigmaSqF=c(0,22500),sigmaSqR=c(0,22500))
rdBed<-makeRangedDataOutput(pics,type="bed",filter=c(myFilter,list(score=c(1,Inf))))


###################################################
### chunk number 12: Create the bed file eval=FALSE
###################################################
## #line 167 "PICS.Rnw"
## library(rtracklayer)
## export(rdBed,"myfile.bed")


###################################################
### chunk number 13: Create the wig file eval=FALSE
###################################################
## #line 175 "PICS.Rnw"
## rdBed<-makeRangedDataOutput(pics,type="wig",filter=c(myFilter,list(score=c(1,Inf))))
## export(rdBed,"myfile.wig")


###################################################
### chunk number 14: 
###################################################
#line 180 "PICS.Rnw"
sfStop()


