###################################################
### chunk number 1: load library
###################################################
#line 73 "PCpheno.Rnw"
library(PCpheno)
data(DudleyPhenoM)
##Number of genes sensitive at each condition
colSums(DudleyPhenoM)
##Retrieve the name of the sensitive genes in each condition
DudleyPhenoL <- apply(DudleyPhenoM,2,function(x) names(which(x==1)))
DudleyPhenoL[1]


###################################################
### chunk number 2: KEGG
###################################################
#line 101 "PCpheno.Rnw"
library(org.Sc.sgd.db) ## new YEAST annotation package
##library(annotate)
KeggMat <- PWAmat("org.Sc.sgd") 
KeggMat[1:5, 1:5]


###################################################
### chunk number 3: ScISI
###################################################
#line 130 "PCpheno.Rnw"
library(ScISI)
data(ScISIC)
ScISIC[1:5, 1:5]


###################################################
### chunk number 4: 
###################################################
#line 176 "PCpheno.Rnw"
perm <- 10 
paraquat <- DudleyPhenoL[["Paraq"]]
parDensity <- densityEstimate(genename=paraquat, interactome=ScISIC, perm=perm) 


###################################################
### chunk number 5: 
###################################################
#line 186 "PCpheno.Rnw"
plot(parDensity, main="Effect of paraquat on S. cerevisiae genes")


###################################################
### chunk number 6: 
###################################################
#line 216 "PCpheno.Rnw"
parGraph <- graphTheory(genename=paraquat, interactome=ScISIC, perm=perm) 


###################################################
### chunk number 7: 
###################################################
#line 225 "PCpheno.Rnw"
plot(parGraph, main="Effect of paraquat S. cerevisiae genes")


###################################################
### chunk number 8: 
###################################################
#line 246 "PCpheno.Rnw"
params <- new("CoHyperGParams",
              geneIds=paraquat, 
              universeGeneIds=rownames(ScISIC),
              annotation="org.Sc.sgd",
              categoryName="ScISIC",
              pvalueCutoff=0.01,
              testDirection="over")

paraquat.complex <- hyperGTest(params)


###################################################
### chunk number 9: 
###################################################
#line 261 "PCpheno.Rnw"
summary(paraquat.complex)[,1:6]


###################################################
### chunk number 10: 
###################################################
#line 267 "PCpheno.Rnw"
status <- complexStatus(data=paraquat.complex,
                              phenotype=paraquat,
                              interactome=ScISIC, threshold=0.01)

descr <- getDescr(status$A, database= c("GO","MIPS"))

data.frame( descr,"pvalues"=paraquat.complex@pvalues[status$A])


