###################################################
### chunk number 1: intro1
###################################################
#line 112 "MLprac2_2.Rnw"
library(MASS)
data(crabs)
dim(crabs)
crabs[1:4,]
table(crabs$sex)


###################################################
### chunk number 2: dolat
###################################################
#line 119 "MLprac2_2.Rnw"
library(lattice)
print(bwplot(RW~sp|sex, data=crabs))


###################################################
### chunk number 3: dop
###################################################
#line 149 "MLprac2_2.Rnw"
m1 = glm(sp~RW, data=crabs, fam=binomial)
summary(m1)


###################################################
### chunk number 4: domods
###################################################
#line 169 "MLprac2_2.Rnw"
table(predict(m1,type="response")>.5, crabs$sp)
m2 = update(m1, subset=sex=="F")
table(predict(m2,type="response")>.5, crabs$sp[crabs$sex=="F"])


###################################################
### chunk number 5: doml1
###################################################
#line 202 "MLprac2_2.Rnw"
library(MLInterfaces)
fcrabs = crabs[crabs$sex == "F", ]
ml1 = MLearn( sp~RW, fcrabs, glmI.logistic(thresh=.5), c(1:30, 51:80), family=binomial)
ml1
confuMat(ml1)


###################################################
### chunk number 6: doscra
###################################################
#line 232 "MLprac2_2.Rnw"
set.seed(123)
sfcrabs = fcrabs[ sample(1:100, size=100, replace=FALSE),  ]


###################################################
### chunk number 7: domods
###################################################
#line 239 "MLprac2_2.Rnw"
sml1 = MLearn( sp~RW, sfcrabs, glmI.logistic(thresh=.5), c(1:30, 51:80), family=binomial)
confuMat(sml1)
smx1 = MLearn( sp~RW, sfcrabs, glmI.logistic(thresh=.5), xvalSpec("LOG",
   5, function(data, clab, iternum) { which(rep(1:5, each=20) == iternum) }), family=binomial)
confuMat(smx1)


###################################################
### chunk number 8: dopa
###################################################
#line 266 "MLprac2_2.Rnw"
pairs(crabs[,-c(1:3)], col=ifelse(crabs$sp=="B", "blue", "orange"))


###################################################
### chunk number 9: dopc
###################################################
#line 293 "MLprac2_2.Rnw"
pc1 = prcomp( crabs[,-c(1:3)] )


###################################################
### chunk number 10: lkpc
###################################################
#line 295 "MLprac2_2.Rnw"
pairs(pc1$x, col=ifelse(crabs$sp=="B", "blue", "orange"))


###################################################
### chunk number 11: dobi
###################################################
#line 303 "MLprac2_2.Rnw"
biplot(pc1, choices=2:3)


###################################################
### chunk number 12: dohm
###################################################
#line 343 "MLprac2_2.Rnw"
X = data.matrix(crabs[,-c(1:3)])
heatmap(t(X), ColSideColors=ifelse(crabs$sp=="O", "orange", "blue"))


###################################################
### chunk number 13: docl
###################################################
#line 372 "MLprac2_2.Rnw"
cl = hclust(dist(X))
tr = cutree(cl,2)
table(tr)


###################################################
### chunk number 14: dos
###################################################
#line 376 "MLprac2_2.Rnw"
library(cluster)
sil = silhouette( tr, dist(X) )
plot(sil)


###################################################
### chunk number 15: newes
###################################################
#line 418 "MLprac2_2.Rnw"
feat2 = t(data.matrix(crabs[, -c(1:3)]))
pd2 = new("AnnotatedDataFrame", crabs[,1:2])
crES = new("ExpressionSet", exprs=feat2, phenoData=pd2)
crES$spsex = paste(crES$sp, crES$sex, sep=":")
table(crES$spsex)


###################################################
### chunk number 16: doper
###################################################
#line 428 "MLprac2_2.Rnw"
set.seed(1234)
crES = crES[ , sample(1:200, size=200, replace=FALSE)]


###################################################
### chunk number 17: dotr
###################################################
#line 435 "MLprac2_2.Rnw"
library(rpart)
tr1 = MLearn(spsex~., crES, rpartI, 1:140)
tr1
confuMat(tr1)


###################################################
### chunk number 18: doplTree
###################################################
#line 443 "MLprac2_2.Rnw"
plot(RObject(tr1))
text(RObject(tr1))


###################################################
### chunk number 19: doccp
###################################################
#line 449 "MLprac2_2.Rnw"
plotcp(RObject(tr1))


###################################################
### chunk number 20: dorf
###################################################
#line 461 "MLprac2_2.Rnw"
set.seed(124)
library(randomForest)
rf1 = MLearn(spsex~., crES, randomForestI, 1:140 )
rf1
cm = confuMat(rf1)
cm


###################################################
### chunk number 21: dold
###################################################
#line 483 "MLprac2_2.Rnw"
ld1 = MLearn(spsex~., crES, ldaI, 1:140 )
ld1
confuMat(ld1)
xvld = MLearn( spsex~., crES, ldaI, xvalSpec("LOG", 5, balKfold.xvspec(5)))
confuMat(xvld)


###################################################
### chunk number 22: dnn
###################################################
#line 503 "MLprac2_2.Rnw"
nn1 = MLearn(spsex~., crES, nnetI, 1:140, size=3, decay=.1)
nn1
RObject(nn1)
confuMat(nn1)


###################################################
### chunk number 23: doxx
###################################################
#line 508 "MLprac2_2.Rnw"
xvnnBAD = MLearn( spsex~., crES, nnetI, 
    xvalSpec("LOG", 5, function(data, clab, iternum) {
      which( rep(1:5,each=40) == iternum ) }),
      size=3, decay=.1 )
xvnnGOOD = MLearn( spsex~., crES, nnetI, 
    xvalSpec("LOG", 5, balKfold.xvspec(5) ),
      size=3, decay=.1 )


###################################################
### chunk number 24: lktann
###################################################
#line 516 "MLprac2_2.Rnw"
confuMat(xvnnBAD)
confuMat(xvnnGOOD)


###################################################
### chunk number 25: dnn
###################################################
#line 523 "MLprac2_2.Rnw"
sv1 = MLearn(spsex~., crES, svmI, 1:140)
sv1
RObject(sv1)
confuMat(sv1)


###################################################
### chunk number 26: doxxs
###################################################
#line 528 "MLprac2_2.Rnw"
xvsv = MLearn( spsex~., crES, svmI, xvalSpec("LOG", 5,
    balKfold.xvspec(5)))


###################################################
### chunk number 27: lktasv
###################################################
#line 531 "MLprac2_2.Rnw"
confuMat(xvsv)


###################################################
### chunk number 28: setupALL
###################################################
#line 547 "MLprac2_2.Rnw"
library(ALL)
data(ALL)
bALL = ALL[, substr(ALL$BT,1,1) == "B"]
fus = bALL[, bALL$mol.biol %in% c("BCR/ABL", "NEG")]
fus$mol.biol = factor(fus$mol.biol)
fus


###################################################
### chunk number 29: getq
###################################################
#line 561 "MLprac2_2.Rnw"
mads = apply(exprs(fus),1,mad)
fusk = fus[ mads > sort(mads,decr=TRUE)[300], ]
fcol = ifelse(fusk$mol.biol=="NEG", "green", "red")


###################################################
### chunk number 30: dohALL eval=FALSE
###################################################
## #line 570 "MLprac2_2.Rnw"
## heatmap(exprs(fusk), ColSideColors=fcol)


###################################################
### chunk number 31: dopcALL
###################################################
#line 578 "MLprac2_2.Rnw"
PCg = prcomp(t(exprs(fusk)))


###################################################
### chunk number 32: lkscre
###################################################
#line 580 "MLprac2_2.Rnw"
plot(PCg)


###################################################
### chunk number 33: lkprALL
###################################################
#line 582 "MLprac2_2.Rnw"
pairs(PCg$x[,1:5],col=fcol,pch=19)


###################################################
### chunk number 34: dobiALL
###################################################
#line 584 "MLprac2_2.Rnw"
biplot(PCg)


###################################################
### chunk number 35: dld
###################################################
#line 616 "MLprac2_2.Rnw"
dld1 = MLearn( mol.biol~., fusk, dldaI, 1:40 )
dld1
confuMat(dld1)
nnALL = MLearn( mol.biol~., fusk, nnetI, 1:40, size=5, decay=.01,
  MaxNWts=2000 )
confuMat(nnALL)
rfALL = MLearn( mol.biol~., fusk, randomForestI, 1:40 )
rfALL
confuMat(rfALL)


###################################################
### chunk number 36: lkrda
###################################################
#line 637 "MLprac2_2.Rnw"
rdaALL = MLearn( mol.biol~., fusk, rdacvI, 1:40 )


###################################################
### chunk number 37: lkrda2
###################################################
#line 639 "MLprac2_2.Rnw"
rdaALL
confuMat(rdaALL)


###################################################
### chunk number 38: getgl
###################################################
#line 646 "MLprac2_2.Rnw"
library(hgu95av2.db)
psid = RObject(rdaALL)$keptFeatures
psid = gsub("^X", "", psid) # make.names is run inopportunely
mget(psid, hgu95av2GENENAME)[1:5]


###################################################
### chunk number 39: getko
###################################################
#line 678 "MLprac2_2.Rnw"
library(keggorthology)
data(KOgraph)
adj(KOgraph, nodes(KOgraph)[1])
EIP = getKOprobes("Environmental Information Processing")
GIP = getKOprobes("Genetic Information Processing")
length(intersect(EIP, GIP))
EIPi = setdiff(EIP, GIP)
GIP = setdiff(GIP, EIP)
EIP = EIPi
Efusk = fusk[ featureNames(fusk) %in% EIP, ]
Gfusk = fusk[ featureNames(fusk) %in% GIP, ]


###################################################
### chunk number 40: dofs
###################################################
#line 709 "MLprac2_2.Rnw"
dldFS = MLearn( mol.biol~., fusk, dldaI, xvalSpec("LOG", 5,
   balKfold.xvspec(5), fs.absT(30) ))
dldFS
confuMat(dld1)
confuMat(dldFS)


