###################################################
### chunk number 1:  eval=FALSE
###################################################
## #line 62 "MEDIPS.Rnw"
## packageDescription("BSgenome")
## packageDescription("gtools")


###################################################
### chunk number 2:  eval=FALSE
###################################################
## #line 70 "MEDIPS.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("BSgenome")
## biocLite("gtools")


###################################################
### chunk number 3:  eval=FALSE
###################################################
## #line 83 "MEDIPS.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("MEDIPS")


###################################################
### chunk number 4: 
###################################################
#line 125 "MEDIPS.Rnw"
library("BSgenome")


###################################################
### chunk number 5: 
###################################################
#line 129 "MEDIPS.Rnw"
available.genomes()


###################################################
### chunk number 6:  eval=FALSE
###################################################
## #line 136 "MEDIPS.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("BSgenome.Hsapiens.UCSC.hg19")


###################################################
### chunk number 7: 
###################################################
#line 152 "MEDIPS.Rnw"
library(MEDIPS)


###################################################
### chunk number 8: 
###################################################
#line 159 "MEDIPS.Rnw"
library(BSgenome.Hsapiens.UCSC.hg19)


###################################################
### chunk number 9: 
###################################################
#line 172 "MEDIPS.Rnw"
file=system.file("extdata", "MeDIP_hESCs_chr22.txt", package="MEDIPS")


###################################################
### chunk number 10: 
###################################################
#line 179 "MEDIPS.Rnw"
CONTROL.SET=MEDIPS.readAlignedSequences(BSgenome="BSgenome.Hsapiens.UCSC.hg19", file=file, numrows=672866)


###################################################
### chunk number 11: 
###################################################
#line 188 "MEDIPS.Rnw"
CONTROL.SET


###################################################
### chunk number 12: 
###################################################
#line 218 "MEDIPS.Rnw"
CONTROL.SET=MEDIPS.genomeVector(data=CONTROL.SET, bin_size=50, extend=400)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## #line 237 "MEDIPS.Rnw"
## MEDIPS.exportWIG(file="output.rpm.control.WIG", data=CONTROL.SET, raw=T, descr="hESCs.rpm")


###################################################
### chunk number 14: 
###################################################
#line 257 "MEDIPS.Rnw"
sr.control=MEDIPS.saturationAnalysis(data=CONTROL.SET, bin_size=50, extend=400, no_iterations=10, no_random_iterations=1)


###################################################
### chunk number 15: 
###################################################
#line 279 "MEDIPS.Rnw"
sr.control


###################################################
### chunk number 16: 
###################################################
#line 290 "MEDIPS.Rnw"
MEDIPS.plotSaturation(sr.control)


###################################################
### chunk number 17: 
###################################################
#line 327 "MEDIPS.Rnw"
CONTROL.SET=MEDIPS.getPositions(data=CONTROL.SET, pattern="CG")


###################################################
### chunk number 18: 
###################################################
#line 349 "MEDIPS.Rnw"
cr.control=MEDIPS.coverageAnalysis(data=CONTROL.SET, extend=400, no_iterations=10)


###################################################
### chunk number 19: 
###################################################
#line 361 "MEDIPS.Rnw"
cr.control


###################################################
### chunk number 20: 
###################################################
#line 373 "MEDIPS.Rnw"
MEDIPS.plotCoverage(cr.control)


###################################################
### chunk number 21: 
###################################################
#line 406 "MEDIPS.Rnw"
er.control=MEDIPS.CpGenrich(data=CONTROL.SET)


###################################################
### chunk number 22: 
###################################################
#line 413 "MEDIPS.Rnw"
er.control


###################################################
### chunk number 23: 
###################################################
#line 442 "MEDIPS.Rnw"
CONTROL.SET=MEDIPS.couplingVector(data=CONTROL.SET, fragmentLength=700, func="count")


###################################################
### chunk number 24:  eval=FALSE
###################################################
## #line 483 "MEDIPS.Rnw"
## MEDIPS.exportWIG(file="PatternDensity.WIG", data=CONTROL.SET, pattern.density=TRUE, descr="Pattern.density")


###################################################
### chunk number 25: 
###################################################
#line 500 "MEDIPS.Rnw"
CONTROL.SET=MEDIPS.calibrationCurve(data=CONTROL.SET)


###################################################
### chunk number 26: 
###################################################
#line 513 "MEDIPS.Rnw"
png("CalibrationPlotCONTROL.png")
MEDIPS.plotCalibrationPlot(data=CONTROL.SET, linearFit=T, plot_chr="chr22")
dev.off()


###################################################
### chunk number 27:  eval=FALSE
###################################################
## #line 519 "MEDIPS.Rnw"
## MEDIPS.plotCalibrationPlot(data=CONTROL.SET, linearFit=T, plot_chr="chr22")


###################################################
### chunk number 28: 
###################################################
#line 646 "MEDIPS.Rnw"
CONTROL.SET=MEDIPS.normalize(data=CONTROL.SET)


###################################################
### chunk number 29:  eval=FALSE
###################################################
## #line 668 "MEDIPS.Rnw"
## MEDIPS.exportWIG(file="output.rms.control.WIG", data=CONTROL.SET, raw=F, descr="hESCs.rms")


###################################################
### chunk number 30: 
###################################################
#line 675 "MEDIPS.Rnw"
CONTROL.SET


###################################################
### chunk number 31: 
###################################################
#line 712 "MEDIPS.Rnw"
file=system.file("extdata", "hg19.chr22.txt", package="MEDIPS")
promoter = MEDIPS.methylProfiling(data1 = CONTROL.SET, ROI_file = file, math = mean, select = 2)


###################################################
### chunk number 32: 
###################################################
#line 836 "MEDIPS.Rnw"
hist(promoter$coupling, breaks=100, main="Promoter CpG densities", xlab="CpG coupling factors")


###################################################
### chunk number 33: 
###################################################
#line 843 "MEDIPS.Rnw"
hist(promoter$rpm_A[promoter$rpm_A!=0], breaks=100, main="RPM signals", xlab="reads/bin")


###################################################
### chunk number 34: 
###################################################
#line 851 "MEDIPS.Rnw"
hist(promoter$ams_A[promoter$ams_A!=0], breaks=100, main="AMS signals", xlab="absolute methylation score (ams)")


###################################################
### chunk number 35:  eval=FALSE
###################################################
## #line 866 "MEDIPS.Rnw"
## frames.frame500.step250=MEDIPS.methylProfiling(data1=CONTROL.SET, frame_size=500, step=250, math=mean, select=2)


###################################################
### chunk number 36:  eval=FALSE
###################################################
## #line 874 "MEDIPS.Rnw"
## write.table(frames.frame500.step250, file="frames.chr22.meth.txt", sep="\t", quote=F, col.names=T, row.names=F)


###################################################
### chunk number 37:  eval=FALSE
###################################################
## #line 883 "MEDIPS.Rnw"
## frames.frame500.step250=read.table(file="frames.chr22.meth.txt", header=T)


###################################################
### chunk number 38: 
###################################################
#line 902 "MEDIPS.Rnw"
file=system.file("extdata", "MeDIP_DE_chr22.txt", package="MEDIPS")
TREAT.SET=MEDIPS.readAlignedSequences(BSgenome="BSgenome.Hsapiens.UCSC.hg19", file=file, numrows=863054)


###################################################
### chunk number 39: 
###################################################
#line 907 "MEDIPS.Rnw"
TREAT.SET=MEDIPS.genomeVector(data=TREAT.SET, bin_size=50, extend=400)


###################################################
### chunk number 40: 
###################################################
#line 910 "MEDIPS.Rnw"
TREAT.SET=MEDIPS.getPositions(data=TREAT.SET, pattern="CG")


###################################################
### chunk number 41: 
###################################################
#line 913 "MEDIPS.Rnw"
TREAT.SET=MEDIPS.couplingVector(data=TREAT.SET, fragmentLength=700, func="count")


###################################################
### chunk number 42: 
###################################################
#line 916 "MEDIPS.Rnw"
TREAT.SET=MEDIPS.calibrationCurve(data=TREAT.SET)


###################################################
### chunk number 43: 
###################################################
#line 919 "MEDIPS.Rnw"
TREAT.SET=MEDIPS.normalize(data=TREAT.SET)


###################################################
### chunk number 44: 
###################################################
#line 931 "MEDIPS.Rnw"
file=system.file("extdata", "Input_StemCells_chr22.txt", package="MEDIPS")
INPUT.SET=MEDIPS.readAlignedSequences(BSgenome="BSgenome.Hsapiens.UCSC.hg19", file=file, numrows=352756)


###################################################
### chunk number 45: 
###################################################
#line 936 "MEDIPS.Rnw"
INPUT.SET=MEDIPS.genomeVector(data=INPUT.SET, bin_size=50, extend=400)


###################################################
### chunk number 46:  eval=FALSE
###################################################
## #line 948 "MEDIPS.Rnw"
## MEDIPS.exportWIG(file="output.rpm.input.WIG", data=INPUT.SET, raw=T, descr="INPUT.rpm")


###################################################
### chunk number 47:  eval=FALSE
###################################################
## #line 952 "MEDIPS.Rnw"
## sr.input=MEDIPS.saturationAnalysis(data=INPUT.SET, bin_size=50, extend=400, no_iterations=10, no_random_iterations=1)
## MEDIPS.plotSaturation(sr.input)


###################################################
### chunk number 48:  eval=FALSE
###################################################
## #line 960 "MEDIPS.Rnw"
## INPUT.SET=MEDIPS.getPositions(data=INPUT.SET, pattern="CG")


###################################################
### chunk number 49:  eval=FALSE
###################################################
## #line 964 "MEDIPS.Rnw"
## cr.input=MEDIPS.coverageAnalysis(data=INPUT.SET, extend=400, no_iterations=10)
## MEDIPS.plotCoverage(cr.input)


###################################################
### chunk number 50:  eval=FALSE
###################################################
## #line 969 "MEDIPS.Rnw"
## er.input=MEDIPS.CpGenrich(data=INPUT.SET)


###################################################
### chunk number 51:  eval=FALSE
###################################################
## #line 975 "MEDIPS.Rnw"
## INPUT.SET=MEDIPS.couplingVector(data=INPUT.SET, fragmentLength=700, func="count")


###################################################
### chunk number 52:  eval=FALSE
###################################################
## #line 979 "MEDIPS.Rnw"
## INPUT.SET=MEDIPS.calibrationCurve(data=INPUT.SET)


###################################################
### chunk number 53:  eval=FALSE
###################################################
## #line 983 "MEDIPS.Rnw"
## png("CalibrationPlotINPUT.png")
## MEDIPS.plotCalibrationPlot(data=INPUT.SET, linearFit=F, plot_chr="chr22")
## dev.off()


###################################################
### chunk number 54: 
###################################################
#line 1010 "MEDIPS.Rnw"
diff.meth=MEDIPS.methylProfiling(data1=CONTROL.SET, data2=TREAT.SET, input=INPUT.SET, frame_size=500, select=2)


###################################################
### chunk number 55:  eval=FALSE
###################################################
## #line 1092 "MEDIPS.Rnw"
## write.table(diff.meth, file="diff.meth.txt", sep="\t", quote=F, col.names=T, row.names=F)


###################################################
### chunk number 56:  eval=FALSE
###################################################
## #line 1098 "MEDIPS.Rnw"
## diff.meth=read.table(file="diff.meth.txt", header=T)


###################################################
### chunk number 57: 
###################################################
#line 1140 "MEDIPS.Rnw"
diff.meth.control=MEDIPS.selectSignificants(frames=diff.meth, control=T, input=T, up=2, p.value=0.0001, quant=0.99)


###################################################
### chunk number 58:  eval=FALSE
###################################################
## #line 1177 "MEDIPS.Rnw"
## diff.meth.control.merged=MEDIPS.mergeFrames(frames=diff.meth.control)


###################################################
### chunk number 59:  eval=FALSE
###################################################
## #line 1192 "MEDIPS.Rnw"
## write.table(diff.meth.control, file = "DiffMethyl.Up.hESCs.bed", sep = "\t", quote = F, row.names = F, col.names = F)


###################################################
### chunk number 60: 
###################################################
#line 1202 "MEDIPS.Rnw"
file=system.file("extdata", "hg19.chr22.txt", package="MEDIPS")
diff.meth.control.annotated=MEDIPS.annotate(diff.meth.control, anno=file)


###################################################
### chunk number 61: 
###################################################
#line 1225 "MEDIPS.Rnw"
length(unique(diff.meth.control.annotated[,4]))


###################################################
### chunk number 62: 
###################################################
#line 1234 "MEDIPS.Rnw"
diff.meth.treat=MEDIPS.selectSignificants(frames=diff.meth, control=F, input=T, up=2, down=0.5, p.value=0.0001, quant=0.99)


###################################################
### chunk number 63:  eval=FALSE
###################################################
## #line 1237 "MEDIPS.Rnw"
## write.table(diff.meth.treat, file = "DiffMethyl.Up.DE.bed", sep = "\t", quote = F, row.names = F, col.names = F)


###################################################
### chunk number 64: 
###################################################
#line 1241 "MEDIPS.Rnw"
file=system.file("extdata", "hg19.chr22.txt", package="MEDIPS")
diff.meth.treat.annotated=MEDIPS.annotate(diff.meth.treat, anno=file)


###################################################
### chunk number 65: 
###################################################
#line 1246 "MEDIPS.Rnw"
length(unique(diff.meth.treat.annotated[,4]))


