###################################################
### chunk number 1: load.lib
###################################################
#line 64 "LVSmiRNA.Rnw"

library(LVSmiRNA)



###################################################
### chunk number 2: import
###################################################
#line 85 "LVSmiRNA.Rnw"

dir.files <- system.file("extdata", package="LVSmiRNA")
taqman.data <- read.table(file.path(dir.files,"Comparison_Array.txt"),header=TRUE,as.is=TRUE)



###################################################
### chunk number 3: read.mir eval=FALSE
###################################################
## #line 97 "LVSmiRNA.Rnw"
## 
## ## NOT RUN
## MIR <- read.mir(taqman.data)
## 


###################################################
### chunk number 4: load
###################################################
#line 106 "LVSmiRNA.Rnw"

data("MIR-spike-in")



###################################################
### chunk number 5: estVC
###################################################
#line 116 "LVSmiRNA.Rnw"

MIR.RA <- estVC(MIR)



###################################################
### chunk number 6: MIR.RA
###################################################
#line 125 "LVSmiRNA.Rnw"

data("MIR_RA")



###################################################
### chunk number 7: plot
###################################################
#line 135 "LVSmiRNA.Rnw"

plot(MIR.RA)



###################################################
### chunk number 8: lvs
###################################################
#line 145 "LVSmiRNA.Rnw"

MIR.lvs <- lvs(MIR,RA=MIR.RA)



###################################################
### chunk number 9: boxplot
###################################################
#line 154 "LVSmiRNA.Rnw"

boxplot(MIR.lvs)



###################################################
### chunk number 10: summarize
###################################################
#line 165 "LVSmiRNA.Rnw"

ex.1 <- summarize(MIR,RA=MIR.RA,method="rlm")
ex.2 <- summarize(MIR,method="medianpolish")



###################################################
### chunk number 11: multicore eval=FALSE
###################################################
## #line 200 "LVSmiRNA.Rnw"
## 
## require(multicore)
## options(cores=8)
## 
## MIR.RA <- estVC(MIR)
## 


###################################################
### chunk number 12: snow eval=FALSE
###################################################
## #line 218 "LVSmiRNA.Rnw"
## 
## require(snow)
## cl <- makeCluster(8,"SOCK")
## 
## MIR.RA <- estVC(MIR,clName=cl)
## 
## stopCluster(cl)
## 


###################################################
### chunk number 13: mpi eval=FALSE
###################################################
## #line 231 "LVSmiRNA.Rnw"
## 
## cl <- makeCluster(8,"MPI")
## 
## MIR.RA <- estVC(MIR,clName=cl)
## 
## stopCluster(cl)
## 


