###################################################
### chunk number 1: setup
###################################################
#line 207 "IPPD.Rnw"

options(prompt = "R> ", continue = " ", warn = -1, width = 90)                                       



###################################################
### chunk number 2: loadmyo500
###################################################
#line 213 "IPPD.Rnw"

library(IPPD) 
data(myo500)
x <- myo500[,"mz"]
y <- myo500[,"intensities"]
y <- y[x <= 2500]
x <- x[x <= 2500]


###################################################
### chunk number 3: plotmyo500first1000
###################################################
#line 225 "IPPD.Rnw"

layout(matrix(c(1,2), 1, 2))

plot(x[1:1000], y[1:1000], xlab = expression(x[1]~~ldots~~x[1000]), 
     cex.lab = 1.5, cex.axis = 1.25, ylab = expression(y))

plot(x[x >= 804 & x <= 807], y[x >= 804 & x <= 807], 
     xlab = "x: 804 <= x <= 807", 
     cex.lab = 1.5, cex.axis = 1.25, ylab = expression(y), type = "b")

layout(matrix(1))



###################################################
### chunk number 4: fitGauss
###################################################
#line 247 "IPPD.Rnw"

fitGauss <- fitModelParameters(mz = x, intensities = y,
                   model = "Gaussian", fitting = "model", formula.sigma = formula(~mz),
                   control = list(window = 6, threshold = 200))


###################################################
### chunk number 5: fitEMG
###################################################
#line 259 "IPPD.Rnw"

fitEMG <- fitModelParameters(mz = x, intensities = y,
                   model = "EMG", fitting = "model",
                           formula.alpha = formula(~mz),
                           formula.sigma = formula(~mz),
                           formula.mu = formula(~1),
                           control = list(window = 6, threshold = 200))


###################################################
### chunk number 6: assessfit
###################################################
#line 280 "IPPD.Rnw"

show(fitEMG)
mse.EMG <- data.frame(mse = slot(fitEMG,"peakfitresults")[,"rss"] 
                      / slot(fitEMG,"peakfitresults")[,"datapoints"], 
                      peakshape = rep("EMG", nrow( slot(fitEMG,"peakfitresults"))))
mse.Gauss <- data.frame(mse = slot(fitGauss,"peakfitresults")[,"rss"] 
                        / slot(fitGauss,"peakfitresults")[,"datapoints"], 
                        peakshape = rep("Gaussian", nrow( slot(fitGauss,"peakfitresults"))))
mses <- rbind(mse.EMG, mse.Gauss)
with(mses, boxplot(mse ~ peakshape, cex.axis = 1.5, cex.lab = 1.5, ylab = "MSE"))



###################################################
### chunk number 7: assessfitEMGpeak
###################################################
#line 294 "IPPD.Rnw"
visualize(fitEMG, type = "peak", cex.lab = 1.5, cex.axis = 1.25)


###################################################
### chunk number 8: assessfit2
###################################################
#line 303 "IPPD.Rnw"

visualize(fitEMG, type = "model", modelfit = TRUE, 
          parameters = c("sigma", "alpha"), 
          cex.lab = 1.5, cex.axis = 1.25)



###################################################
### chunk number 9: getlist
###################################################
#line 415 "IPPD.Rnw"

EMGlist <- getPeaklist(mz = x, intensities = y, model = "EMG",
model.parameters = fitEMG, 
loss = "L2", trace = FALSE,
control.localnoise = list(factor.place = 2),
control.basis = list(charges = c(1, 2)),
control.postprocessing = list(ppm = 200))

show(EMGlist)



###################################################
### chunk number 10: showlist
###################################################
#line 437 "IPPD.Rnw"

threshold(EMGlist, threshold = 3, refit = TRUE, trace = FALSE)



###################################################
### chunk number 11: plot1
###################################################
#line 449 "IPPD.Rnw"

visualize(EMGlist, x, y, lower= 963, upper = 973,
           fit = FALSE, fittedfunction = TRUE, fittedfunction.cut = TRUE,
           localnoise = TRUE, quantile = 0.5,
           cutoff.functions = 3)



###################################################
### chunk number 12: plot2
###################################################
#line 458 "IPPD.Rnw"


visualize(EMGlist, x, y, lower= 1502, upper = 1510,
           fit = FALSE, fittedfunction = TRUE, fittedfunction.cut = TRUE,
           localnoise = TRUE, quantile = 0.5,
           cutoff.functions = 2)




###################################################
### chunk number 13: plot3
###################################################
#line 475 "IPPD.Rnw"

visualize(EMGlist, x, y, lower= 1360, upper = 1364,
          fit = FALSE, fittedfunction = TRUE, fittedfunction.cut = TRUE,
          localnoise = TRUE, quantile = 0.5, 
          cutoff.functions = 2)



