###################################################
### chunk number 1: Prepare parameters
###################################################
#line 68 "HTqPCR.Rnw"
options(width=65)
set.seed(123)


###################################################
### chunk number 2: Load package
###################################################
#line 84 "HTqPCR.Rnw"
library("HTqPCR")


###################################################
### chunk number 3: Extract R code
###################################################
#line 94 "HTqPCR.Rnw"
all.R.commands <- system.file("doc", "HTqPCR.Rnw", package = "HTqPCR")
Stangle(all.R.commands)


###################################################
### chunk number 4: All functions
###################################################
#line 115 "HTqPCR.Rnw"
ls("package:HTqPCR")


###################################################
### chunk number 5: Load example data
###################################################
#line 154 "HTqPCR.Rnw"
data(qPCRraw)
data(qPCRpros)
class(qPCRraw)


###################################################
### chunk number 6: Example input files
###################################################
#line 181 "HTqPCR.Rnw"
path <- system.file("exData", package="HTqPCR")
head(read.delim(file.path(path, "files.txt")))


###################################################
### chunk number 7: Read raw data
###################################################
#line 190 "HTqPCR.Rnw"
files <- read.delim(file.path(path, "files.txt"))
raw <- readCtData(files=files$File, path=path)


###################################################
### chunk number 8: Show qPCRset data object
###################################################
#line 197 "HTqPCR.Rnw"
show(raw)


###################################################
### chunk number 9: Ct overview ex 1
###################################################
#line 216 "HTqPCR.Rnw"
g <- featureNames(raw)[1:10]
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, conf.int=TRUE, 
ylim=c(0,55))


###################################################
### chunk number 10: Ct overview ex 2
###################################################
#line 222 "HTqPCR.Rnw"
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, 
calibrator="Control")


###################################################
### chunk number 11: 
###################################################
#line 229 "HTqPCR.Rnw"
par(mfrow=c(2,1))
#line 216 "HTqPCR.Rnw"
g <- featureNames(raw)[1:10]
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, conf.int=TRUE, 
ylim=c(0,55))
#line 231 "HTqPCR.Rnw"
#line 222 "HTqPCR.Rnw"
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, 
calibrator="Control")
#line 232 "HTqPCR.Rnw"


###################################################
### chunk number 12: Ct card ex 1
###################################################
#line 243 "HTqPCR.Rnw"
plotCtCard(raw, col.range=c(10,35), well.size=2.6)


###################################################
### chunk number 13: Ct card ex 2
###################################################
#line 246 "HTqPCR.Rnw"
featureClass(raw) <- factor(c("Marker", "TF", "Kinase")[sample(c(1,1,2,2,1,3), 
384, replace=TRUE)])
plotCtCard(raw, plot="class", well.size=2.6)


###################################################
### chunk number 14: 
###################################################
#line 254 "HTqPCR.Rnw"
#line 243 "HTqPCR.Rnw"
plotCtCard(raw, col.range=c(10,35), well.size=2.6)
#line 255 "HTqPCR.Rnw"


###################################################
### chunk number 15: 
###################################################
#line 257 "HTqPCR.Rnw"
#line 246 "HTqPCR.Rnw"
featureClass(raw) <- factor(c("Marker", "TF", "Kinase")[sample(c(1,1,2,2,1,3), 
384, replace=TRUE)])
plotCtCard(raw, plot="class", well.size=2.6)
#line 258 "HTqPCR.Rnw"


###################################################
### chunk number 16: Ct replicates
###################################################
#line 269 "HTqPCR.Rnw"
plotCtReps(qPCRraw, card=2, percent=20)


###################################################
### chunk number 17: 
###################################################
#line 275 "HTqPCR.Rnw"
#line 269 "HTqPCR.Rnw"
plotCtReps(qPCRraw, card=2, percent=20)
#line 276 "HTqPCR.Rnw"


###################################################
### chunk number 18: Ct variation ex 1
###################################################
#line 291 "HTqPCR.Rnw"
raw.mix	<- raw
exprs(raw.mix)[,6]	<- sample(exprs(raw[,6]))
plotCtVariation(raw.mix, variation="sd", log=TRUE, main="SD of replicated features", col="lightgrey")


###################################################
### chunk number 19: Ct variation ex 2
###################################################
#line 299 "HTqPCR.Rnw"
raw.variation	<- plotCtVariation(raw.mix, type="detail", add.featurenames=TRUE, pch=" ", cex=1.2)


###################################################
### chunk number 20: Ct variation ex 2 in detail
###################################################
#line 302 "HTqPCR.Rnw"
names(raw.variation)
head(raw.variation[["Var"]][,1:4])
head(raw.variation[["Mean"]][,1:4])
apply(raw.variation[["Var"]][,3:7], 2, summary)
colSums(raw.variation[["Var"]][,3:7]>20)


###################################################
### chunk number 21: 
###################################################
#line 314 "HTqPCR.Rnw"
#line 291 "HTqPCR.Rnw"
raw.mix	<- raw
exprs(raw.mix)[,6]	<- sample(exprs(raw[,6]))
plotCtVariation(raw.mix, variation="sd", log=TRUE, main="SD of replicated features", col="lightgrey")
#line 315 "HTqPCR.Rnw"


###################################################
### chunk number 22: 
###################################################
#line 317 "HTqPCR.Rnw"
#line 299 "HTqPCR.Rnw"
raw.variation	<- plotCtVariation(raw.mix, type="detail", add.featurenames=TRUE, pch=" ", cex=1.2)
#line 318 "HTqPCR.Rnw"


###################################################
### chunk number 23: Set Ct categories
###################################################
#line 342 "HTqPCR.Rnw"
raw.cat <- setCategory(raw, groups=files$Treatment, quantile=0.8)


###################################################
### chunk number 24: Plot Ct categories ex 1
###################################################
#line 349 "HTqPCR.Rnw"
plotCtCategory(raw.cat)


###################################################
### chunk number 25: Plot Ct categories ex 2
###################################################
#line 352 "HTqPCR.Rnw"
plotCtCategory(raw.cat, stratify="class")


###################################################
### chunk number 26: 
###################################################
#line 358 "HTqPCR.Rnw"
par(mfrow=c(2,1))
#line 349 "HTqPCR.Rnw"
plotCtCategory(raw.cat)
#line 360 "HTqPCR.Rnw"
#line 352 "HTqPCR.Rnw"
plotCtCategory(raw.cat, stratify="class")
#line 361 "HTqPCR.Rnw"


###################################################
### chunk number 27: Plot Ct categories ex 3
###################################################
#line 370 "HTqPCR.Rnw"
plotCtCategory(raw.cat, by.feature=TRUE, cexRow=0.1)


###################################################
### chunk number 28: 
###################################################
#line 376 "HTqPCR.Rnw"
#line 370 "HTqPCR.Rnw"
plotCtCategory(raw.cat, by.feature=TRUE, cexRow=0.1)
#line 377 "HTqPCR.Rnw"


###################################################
### chunk number 29: Normalise data
###################################################
#line 412 "HTqPCR.Rnw"
q.norm <- normalizeCtData(raw.cat, norm="quantile")
sr.norm <- normalizeCtData(raw.cat, norm="scale.rank")
nr.norm <- normalizeCtData(raw.cat, norm="norm.rank")
d.norm <- normalizeCtData(raw.cat, norm="deltaCt", deltaCt.genes=c("Gene1", "Gene60"))


###################################################
### chunk number 30: Normalisation comparison
###################################################
#line 421 "HTqPCR.Rnw"
plot(exprs(raw), exprs(q.norm), pch=20, main="Quantile normalisation", col=rep(brewer.pal(6, "Spectral"), each=384))


###################################################
### chunk number 31: 
###################################################
#line 427 "HTqPCR.Rnw"
col <- rep(brewer.pal(6, "Spectral"), each=384)
col2 <- brewer.pal(5, "Dark2")
par(mfrow=c(3,2), mar=c(2,2,2,2))
# All methods individually
plot(exprs(raw), exprs(q.norm), pch=20, main="Quantile normalisation", col=col)
plot(exprs(raw), exprs(sr.norm), pch=20, main="Rank invariant scaling", col=col)
plot(exprs(raw), exprs(nr.norm), pch=20, main="Rank invariant normalisation", col=col)
plot(exprs(raw), exprs(d.norm), pch=20, main="deltaCt normalisation", col=col)
# Just a single sample, across methods
plot(exprs(raw)[,1], exprs(q.norm)[,1], pch=20, col=col2[1], main="Comparison of methods for sample 1", ylim=c(-10,40))
points(exprs(raw)[,1], exprs(sr.norm)[,1], pch=20, col=col2[2])
points(exprs(raw)[,1], exprs(nr.norm)[,1], pch=20, col=col2[3])
points(exprs(raw)[,1], exprs(d.norm)[,1], pch=20, col=col2[4])
legend(8, 40, legend=c("Quantile", "Rank.invariant scaling", "Rank.invariant normalization", "deltaCt"), col=col2, lwd=2, bty="n")


###################################################
### chunk number 32: Subset data
###################################################
#line 458 "HTqPCR.Rnw"
nr.norm[1:10,]
nr.norm[,c(1,3,5)]


###################################################
### chunk number 33: Filter data 1
###################################################
#line 464 "HTqPCR.Rnw"
qFilt   <- filterCtData(nr.norm, remove.type="Endogenous Control")
qFilt   <- filterCtData(nr.norm, remove.name=c("Gene1", "Gene20", "Gene30"))
qFilt   <- filterCtData(nr.norm, remove.class="Kinase")
qFilt   <- filterCtData(nr.norm, remove.type=c("Endogenous Control"), remove.name=c("Gene1", "Gene20", "Gene30"))


###################################################
### chunk number 34: Filter data 2
###################################################
#line 473 "HTqPCR.Rnw"
qFilt   <- filterCtData(nr.norm, remove.category="Undetermined")
qFilt   <- filterCtData(nr.norm, remove.category="Undetermined", n.category=5)


###################################################
### chunk number 35: IQR plot
###################################################
#line 480 "HTqPCR.Rnw"
iqr.values <- apply(exprs(nr.norm), 1, IQR)
hist(iqr.values, n=20, main="", xlab="IQR across samples")
abline(v=1.5, col=2)


###################################################
### chunk number 36: Filter data 3
###################################################
#line 488 "HTqPCR.Rnw"
qFilt   <- filterCtData(nr.norm, remove.IQR=1.5)


###################################################
### chunk number 37: 
###################################################
#line 494 "HTqPCR.Rnw"
#line 480 "HTqPCR.Rnw"
iqr.values <- apply(exprs(nr.norm), 1, IQR)
hist(iqr.values, n=20, main="", xlab="IQR across samples")
abline(v=1.5, col=2)
#line 495 "HTqPCR.Rnw"


###################################################
### chunk number 38: Ct correlations
###################################################
#line 515 "HTqPCR.Rnw"
plotCtCor(raw, main="Ct correlation")


###################################################
### chunk number 39: 
###################################################
#line 521 "HTqPCR.Rnw"
#line 515 "HTqPCR.Rnw"
plotCtCor(raw, main="Ct correlation")
#line 522 "HTqPCR.Rnw"


###################################################
### chunk number 40: Summary of Ct values
###################################################
#line 533 "HTqPCR.Rnw"
summary(raw)


###################################################
### chunk number 41: Ct density
###################################################
#line 540 "HTqPCR.Rnw"
plotCtDensity(sr.norm)


###################################################
### chunk number 42: Ct histogram
###################################################
#line 543 "HTqPCR.Rnw"
plotCtHistogram(sr.norm)


###################################################
### chunk number 43: 
###################################################
#line 552 "HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(3,3,2,1))
#line 540 "HTqPCR.Rnw"
plotCtDensity(sr.norm)
#line 554 "HTqPCR.Rnw"
#line 543 "HTqPCR.Rnw"
plotCtHistogram(sr.norm)
#line 555 "HTqPCR.Rnw"


###################################################
### chunk number 44: 
###################################################
#line 566 "HTqPCR.Rnw"
par(mfrow=c(2,2), mar=c(2,2,2,1))
plotCtDensity(q.norm, main="quantile")
plotCtDensity(sr.norm, main="scale.rankinvariant")
plotCtDensity(nr.norm, main="norm.rankinvariant")
plotCtDensity(d.norm, main="deltaCt")


###################################################
### chunk number 45: Ct boxes
###################################################
#line 580 "HTqPCR.Rnw"
plotCtBoxes(sr.norm, stratify="class")


###################################################
### chunk number 46: 
###################################################
#line 586 "HTqPCR.Rnw"
#line 580 "HTqPCR.Rnw"
plotCtBoxes(sr.norm, stratify="class")
#line 587 "HTqPCR.Rnw"


###################################################
### chunk number 47: Ct scatter ex 1
###################################################
#line 598 "HTqPCR.Rnw"
plotCtScatter(sr.norm, cards=c(1,2), col="type", diag=TRUE)


###################################################
### chunk number 48: Ct scatter ex 2
###################################################
#line 601 "HTqPCR.Rnw"
plotCtScatter(sr.norm, cards=c(1,4), col="class", diag=TRUE)


###################################################
### chunk number 49: 
###################################################
#line 607 "HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(3,3,2,1))
#line 598 "HTqPCR.Rnw"
plotCtScatter(sr.norm, cards=c(1,2), col="type", diag=TRUE)
#line 609 "HTqPCR.Rnw"
#line 601 "HTqPCR.Rnw"
plotCtScatter(sr.norm, cards=c(1,4), col="class", diag=TRUE)
#line 610 "HTqPCR.Rnw"


###################################################
### chunk number 50: Ct pairs
###################################################
#line 622 "HTqPCR.Rnw"
plotCtPairs(sr.norm, col="type", diag=TRUE)


###################################################
### chunk number 51: 
###################################################
#line 628 "HTqPCR.Rnw"
#line 622 "HTqPCR.Rnw"
plotCtPairs(sr.norm, col="type", diag=TRUE)
#line 629 "HTqPCR.Rnw"


###################################################
### chunk number 52: Ct heatmap
###################################################
#line 642 "HTqPCR.Rnw"
plotCtHeatmap(raw, gene.names="", dist="euclidean")


###################################################
### chunk number 53: 
###################################################
#line 648 "HTqPCR.Rnw"
#line 642 "HTqPCR.Rnw"
plotCtHeatmap(raw, gene.names="", dist="euclidean")
#line 649 "HTqPCR.Rnw"


###################################################
### chunk number 54: CV across samples
###################################################
#line 660 "HTqPCR.Rnw"
plotCVBoxes(qPCRraw, stratify="class")
plotCVBoxes(qPCRraw, stratify="type")


###################################################
### chunk number 55: 
###################################################
#line 667 "HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(2,2,2,1))
plotCVBoxes(qPCRraw, stratify="class")
plotCVBoxes(qPCRraw, stratify="type")


###################################################
### chunk number 56: Cluster Ct
###################################################
#line 690 "HTqPCR.Rnw"
clusterCt(sr.norm, type="samples")


###################################################
### chunk number 57: 
###################################################
#line 696 "HTqPCR.Rnw"
#line 690 "HTqPCR.Rnw"
clusterCt(sr.norm, type="samples")
#line 697 "HTqPCR.Rnw"


###################################################
### chunk number 58: Plot subclusters
###################################################
#line 704 "HTqPCR.Rnw"
cluster.list <- clusterCt(sr.norm, type="genes", n.cluster=6, cex=0.5)


###################################################
### chunk number 59: Show subcluster
###################################################
#line 708 "HTqPCR.Rnw"
c6 <- cluster.list[[6]]
print(c6)
show(sr.norm[c6,])


###################################################
### chunk number 60: 
###################################################
#line 716 "HTqPCR.Rnw"
#line 704 "HTqPCR.Rnw"
cluster.list <- clusterCt(sr.norm, type="genes", n.cluster=6, cex=0.5)
#line 717 "HTqPCR.Rnw"


###################################################
### chunk number 61: Principal components analysis
###################################################
#line 728 "HTqPCR.Rnw"
plotCtPCA(qPCRraw)
plotCtPCA(qPCRraw, features=FALSE)


###################################################
### chunk number 62: 
###################################################
#line 735 "HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(2,2,2,1))
plotCtPCA(qPCRraw)
plotCtPCA(qPCRraw, features=FALSE)


###################################################
### chunk number 63: Object history
###################################################
#line 754 "HTqPCR.Rnw"
getCtHistory(sr.norm)
getCtHistory(qFilt)


###################################################
### chunk number 64: Perform standard t-test
###################################################
#line 774 "HTqPCR.Rnw"
qDE.ttest <- ttestCtData(sr.norm[,1:4], groups=files$Treatment[1:4], 
calibrator="Control")
head(qDE.ttest)


###################################################
### chunk number 65: Perform Mann-Whitney test
###################################################
#line 784 "HTqPCR.Rnw"
qDE.mwtest <- mannwhitneyCtData(sr.norm[,1:4], groups=files$Treatment[1:4], 
calibrator="Control")
head(qDE.mwtest)


###################################################
### chunk number 66: Perform limma test
###################################################
#line 794 "HTqPCR.Rnw"
# Preparing experiment design
design <- model.matrix(~0+files$Treatment)
colnames(design) <- c("Control", "LongStarve", "Starve")
print(design)
contrasts <- makeContrasts(LongStarve-Control, LongStarve-Starve, 
Starve-Control, (Starve+LongStarve)/2-Control, levels=design)
colnames(contrasts) <- c("LS-C", "LS-S", "S-C", "bothS-C")
print(contrasts)
# Reorder data to get the genes in consecutive rows
sr.norm2    <- sr.norm[order(featureNames(sr.norm)),] 
qDE.limma       <- limmaCtData(sr.norm2, design=design, contrasts=contrasts, 
ndups=2, spacing=1)


###################################################
### chunk number 67: limma test output
###################################################
#line 811 "HTqPCR.Rnw"
class(qDE.limma)
names(qDE.limma)
head(qDE.limma[["LS-C"]])


###################################################
### chunk number 68: limma summary output
###################################################
#line 819 "HTqPCR.Rnw"
qDE.limma[["Summary"]][21:30,]


###################################################
### chunk number 69: Relative quantification ex 1
###################################################
#line 836 "HTqPCR.Rnw"
plotCtRQ(qDE.ttest, genes=1:15)


###################################################
### chunk number 70: Relative quantification ex 2
###################################################
#line 840 "HTqPCR.Rnw"
plotCtRQ(qDE.limma, p.val=0.085, transform="log10", col="#9E0142")


###################################################
### chunk number 71: 
###################################################
#line 848 "HTqPCR.Rnw"
#line 836 "HTqPCR.Rnw"
plotCtRQ(qDE.ttest, genes=1:15)
#line 849 "HTqPCR.Rnw"


###################################################
### chunk number 72: 
###################################################
#line 858 "HTqPCR.Rnw"
#line 840 "HTqPCR.Rnw"
plotCtRQ(qDE.limma, p.val=0.085, transform="log10", col="#9E0142")
#line 859 "HTqPCR.Rnw"


###################################################
### chunk number 73: Significant Ct
###################################################
#line 870 "HTqPCR.Rnw"
plotCtSignificance(qDE.limma, q=sr.norm, 
groups=files$Treatment, target="LongStarve", 
calibrator="Control", genes=featureNames(sr.norm)[11:20], un.col="#3288BD", jitter=0.2)


###################################################
### chunk number 74: 
###################################################
#line 878 "HTqPCR.Rnw"
#line 870 "HTqPCR.Rnw"
plotCtSignificance(qDE.limma, q=sr.norm, 
groups=files$Treatment, target="LongStarve", 
calibrator="Control", genes=featureNames(sr.norm)[11:20], un.col="#3288BD", jitter=0.2)
#line 879 "HTqPCR.Rnw"


###################################################
### chunk number 75: Heatmap significant Ct
###################################################
#line 890 "HTqPCR.Rnw"
heatmapSig(qDE.limma, dist="euclidean")


###################################################
### chunk number 76: 
###################################################
#line 896 "HTqPCR.Rnw"
#line 890 "HTqPCR.Rnw"
heatmapSig(qDE.limma, dist="euclidean")
#line 897 "HTqPCR.Rnw"


###################################################
### chunk number 77: Multiple samples per card
###################################################
#line 921 "HTqPCR.Rnw"
# Example with 2  or 4 samples per 384 well card.
sample2.order	<- rep(c("subSampleA", "subSampleB"), each=192)
sample4.order	<- rep(c("subA", "subB", "subC", "subD"), each=96)
# Splitting the data into all individual samples
qPCRnew2 <- changeCtLayout(sr.norm, sample.order=sample2.order)
show(qPCRnew2)
qPCRnew4 <- changeCtLayout(sr.norm, sample.order=sample4.order)
show(qPCRnew4)


###################################################
### chunk number 78: Card history
###################################################
#line 934 "HTqPCR.Rnw"
getCtHistory(qPCRnew4)


###################################################
### chunk number 79: Combine qPCRset objects
###################################################
#line 952 "HTqPCR.Rnw"
q.comb	<- cbind(q.norm[,1:3], sr.norm[,4], nr.norm[,c(1,5,6)])
q.comb
q.comb2	<- rbind(q.norm, sr.norm[1:4,], nr.norm)
q.comb2


###################################################
### chunk number 80: Combined card history
###################################################
#line 961 "HTqPCR.Rnw"
getCtHistory(q.comb)


###################################################
### chunk number 81: Example SDS data
###################################################
#line 978 "HTqPCR.Rnw"
path <- system.file("exData", package="HTqPCR")
cat(paste(readLines(file.path(path, "SDS_sample.txt"), n=19), "\n"))


###################################################
### chunk number 82: Example SDS data 2
###################################################
#line 985 "HTqPCR.Rnw"
readLines(file.path(path, "SDS_sample.txt"), n=20)


###################################################
### chunk number 83: Create Fluidigm set 1
###################################################
#line 1005 "HTqPCR.Rnw"
# Get example data
exPath <- system.file("exData", package="HTqPCR")
exFiles <- "fluidigm_sample.csv"
# Reading data into a data frame
temp	<- read.delim(file.path(exPath, exFiles), skip=11, sep=",", colClasses="character")
n	<- 48
# Turn into matrix
mat	<- matrix(as.numeric(temp$Value), ncol=n, nrow=n, byrow=FALSE)
mat[mat>40]	<- NA
# Create qPCRset
raw <- new("qPCRset", exprs=mat, sampleNames=paste("S", 1:n, sep=""), featureNames=paste("A", 1:n, sep=""), featureCategory=as.data.frame(array("OK", c(n,n))))


###################################################
### chunk number 84: Create Fluidigm set 2
###################################################
#line 1021 "HTqPCR.Rnw"
# Create qPCRset object
temp	<- readCtData(exFiles, path=exPath, n.features=48*48, flag=9, feature=5, type=6, Ct=7, position=1, skip=12, sep=",")
# Re-format from 1x2304 samples in input file into 48x48 as on array
raw	<- changeCtLayout(temp, sample.order=rep(1:48, each=48))


###################################################
### chunk number 85: Ct microfluidic array
###################################################
#line 1032 "HTqPCR.Rnw"
plotCtArray(raw)


###################################################
### chunk number 86: 
###################################################
#line 1038 "HTqPCR.Rnw"
#line 1032 "HTqPCR.Rnw"
plotCtArray(raw)
#line 1039 "HTqPCR.Rnw"


###################################################
### chunk number 87: Check HTqPCR news
###################################################
#line 1055 "HTqPCR.Rnw"
news(Version>1.3, package="HTqPCR")


###################################################
### chunk number 88: sessionInfo
###################################################
#line 1061 "HTqPCR.Rnw"
toLatex(sessionInfo())


