### R code from vignette source 'examples.Rnw'

###################################################
### code chunk number 1: SetUp Session
###################################################
library(rtracklayer)
session <- browserSession()


###################################################
### code chunk number 2: Choose Genome
###################################################
head(ucscGenomes())


###################################################
### code chunk number 3: Set Genome
###################################################
genome(session) <- "hg18"


###################################################
### code chunk number 4: Check Available Tracks
###################################################
head(trackNames(session))


###################################################
### code chunk number 5: Simple Query (eval = FALSE)
###################################################
## query <- ucscTableQuery(session, "refGene")


###################################################
### code chunk number 6: Get Table (eval = FALSE)
###################################################
## head(getTable(query))


###################################################
### code chunk number 7: Access SNPs
###################################################
query <- ucscTableQuery(session, "snp130",
                        GenomicRanges(57795963, 57815592, "chr12"))
head(getTable(query)) 


###################################################
### code chunk number 8: SessionInfo
###################################################
sessionInfo()


