/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Mid
extends AbstractFunction {
    public Mid() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRING, "text", "The source text."), new ArgDescriptor(ArgType.INT, "start", "The first position of the selected substring."), new ArgDescriptor(ArgType.INT, "count", "The length of the selected substring.")});
    }

    public String getName() {
        return "MID";
    }

    public String getFunctionSummary() {
        return "Selects a substring of some text.";
    }

    public Class getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        int count;
        int start;
        String text = FunctionUtil.getArgAsString(args[0]);
        try {
            start = (int)FunctionUtil.getArgAsLong(args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to a start position in a call to MID()!");
        }
        try {
            count = (int)FunctionUtil.getArgAsLong(args[2]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[2] + "\" to a count in a call to MID()!");
        }
        if (start < 1) {
            throw new IllegalArgumentException("illegal start position in call to MID()!");
        }
        if (count < 0) {
            throw new IllegalArgumentException("illegal character count in call to MID()!");
        }
        if (count >= text.length() - start + 1) {
            return text.substring(start - 1);
        }
        return text.substring(start - 1, start + count - 1);
    }
}

