/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyException;
import org.biojava.ontology.OntologyFactory;
import org.biojava.ontology.Term;
import org.biojava.utils.ChangeVetoException;

public class GOParser {
    public Ontology parseGO(BufferedReader goFile, String ontoName, String ontoDescription, OntologyFactory factory) throws ParseException, IOException {
        try {
            String line;
            Ontology onto = factory.createOntology(ontoName, ontoDescription);
            Term isa = onto.importTerm(OntoTools.IS_A, null);
            Term partof = null;
            ArrayList<Term> termStack = new ArrayList<Term>();
            while ((line = goFile.readLine()) != null) {
                int leadSpaces = 0;
                while (line.charAt(leadSpaces) == ' ') {
                    ++leadSpaces;
                }
                if ((line = line.trim()).startsWith("!")) continue;
                StringTokenizer toke = new StringTokenizer(line, "%<$", true);
                String parentRel = toke.nextToken();
                Term term = this.parseTerm(onto, toke.nextToken());
                if (parentRel.equals("%")) {
                    this.safeAddTriple(onto, term, (Term)termStack.get(leadSpaces - 1), isa);
                } else if (parentRel.equals("<")) {
                    this.safeAddTriple(onto, term, (Term)termStack.get(leadSpaces - 1), partof);
                }
                while (toke.hasMoreTokens()) {
                    String altRel = toke.nextToken();
                    Term altTerm = this.parseTerm(onto, toke.nextToken());
                    if (altRel.equals("%")) {
                        this.safeAddTriple(onto, term, altTerm, isa);
                        continue;
                    }
                    if (!altRel.equals("<")) continue;
                    this.safeAddTriple(onto, term, altTerm, partof);
                }
                if (termStack.size() == leadSpaces) {
                    termStack.add(term);
                    continue;
                }
                termStack.set(leadSpaces, term);
            }
            return onto;
        }
        catch (AlreadyExistsException ex) {
            throw new ParseException(ex, "Duplication in ontology");
        }
        catch (OntologyException ex) {
            throw new ParseException(ex);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Error accessing newly created ontology", ex);
        }
    }

    private void safeAddTriple(Ontology onto, Term s, Term o, Term p) throws AlreadyExistsException, ChangeVetoException {
        if (!onto.containsTriple(s, o, p)) {
            onto.createTriple(s, o, p, null, null);
        }
    }

    private Term parseTerm(Ontology onto, String s) throws ParseException, AlreadyExistsException, ChangeVetoException {
        int semi = s.indexOf(59);
        int semi2 = s.indexOf(59, semi + 1);
        if (semi < 0) {
            throw new ParseException("No semicolon in " + s);
        }
        String termDesc = s.substring(0, semi).trim();
        String termName = semi2 < 0 ? s.substring(semi + 1).trim() : s.substring(semi + 1, semi2).trim();
        StringTokenizer toke = new StringTokenizer(termName, ", ");
        if (onto.containsTerm(termName = toke.nextToken())) {
            return onto.getTerm(termName);
        }
        Term t = onto.createTerm(termName, termDesc);
        if (toke.hasMoreTokens()) {
            ArrayList<String> secondaries = new ArrayList<String>();
            while (toke.hasMoreTokens()) {
                secondaries.add(toke.nextToken());
            }
            t.getAnnotation().setProperty("go.secondary_ids", secondaries);
        }
        return t;
    }
}

