/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.AxisLabelsTraverser;
import jas.hist.BinnedDataAxisAttributesNodeTraverser;
import jas.hist.Bins1DNodeTraverser;
import jas.hist.ClassNodeTraverser;
import jas.hist.ConstructorNodeTraverser;
import jas.hist.DataSource;
import jas.hist.DataSourceNodeTraverser;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.NormalizationTraverser;
import jas.hist.PointDataAxisAttributesNodeTraverser;
import jas.hist.StatisticsTraverser;
import jas.hist.Style1DNodeTraverser;
import jas.hist.XML1DHistDataSource;
import jas.hist.XMLXYDataSource;
import jas.hist.XYPointsNodeTraverser;
import jas.hist.normalization.Normalizer;
import jas.util.xml.XMLNodeTraverser;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Data1DTraverser
extends XMLNodeTraverser {
    private int yAxis;
    private StatisticsTraverser stats = null;
    private AxisLabelsTraverser labels = null;
    private NormalizationTraverser norm = null;
    private JASHist1DHistogramStyle style = null;
    private ConstructorNodeTraverser ct = null;
    private Style1DNodeTraverser st = new Style1DNodeTraverser();
    private Bins1DNodeTraverser b1d;
    private XYPointsNodeTraverser xy;
    private PointDataAxisAttributesNodeTraverser paa;
    private BinnedDataAxisAttributesNodeTraverser baa;
    private String refName;

    Data1DTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("bins1d")) {
            this.b1d = new Bins1DNodeTraverser(node);
        } else if (name.equals("points")) {
            this.xy = new XYPointsNodeTraverser(node);
        } else if (name.equals("binnedDataAxisAttributes")) {
            this.baa = new BinnedDataAxisAttributesNodeTraverser(node);
        } else if (name.equals("pointDataAxisAttributes")) {
            this.paa = new PointDataAxisAttributesNodeTraverser(node);
        } else if (name.equals("class")) {
            this.ct = new ClassNodeTraverser(node);
        } else if (name.equals("datasource")) {
            this.ct = new DataSourceNodeTraverser(node);
        } else if (name.equals("statistics")) {
            this.stats = new StatisticsTraverser(node);
        } else if (name.equals("axisLabels")) {
            this.labels = new AxisLabelsTraverser(node);
        } else if (name.equals("style1d")) {
            this.style = new JASHist1DHistogramStyle();
            this.st.traverse(node, this.style);
        } else if (name.equals("normalization")) {
            this.norm = new NormalizationTraverser(node);
        } else {
            super.handleElement(node, name);
        }
    }

    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("axis")) {
            this.yAxis = this.toInt(value.substring(1));
        } else if (name.equals("name")) {
            this.refName = value;
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    DataSource getDataSource() {
        if (this.ct != null) {
            return this.ct.getDataSource();
        }
        if (this.b1d != null) {
            return new XML1DHistDataSource(this.b1d, this.baa, this.labels, this.stats);
        }
        return new XMLXYDataSource(this.xy, this.paa, this.stats);
    }

    int getYAxis() {
        return this.yAxis;
    }

    JASHistStyle getStyle() {
        return this.style;
    }

    String getRefName() {
        return this.refName;
    }

    Normalizer getNormalizer(DataSource data, Hashtable map) throws XMLNodeTraverser.BadXMLException {
        return this.norm == null ? null : this.norm.getNormalizer(data, map);
    }
}

