/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.CompositionFactory;
import com.sun.glf.util.TextBeans;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import javax.swing.JOptionPane;

public final class CompositionFactoryLoader {
    static final String ERROR_NOT_A_COMPOSITION_FACTORY = "Error: not a CompositionFactory bean";
    static final String ERROR_CANNOT_LOAD_BEAN = "Error. Cannot load bean : ";

    public static CompositionFactory loadBeanFile(File file) {
        CompositionFactory compositionFactory = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getAbsolutePath().toLowerCase().endsWith(".ser.txt")) {
                compositionFactory = (CompositionFactory)TextBeans.read(fileInputStream);
            } else {
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                compositionFactory = (CompositionFactory)objectInputStream.readObject();
                objectInputStream.close();
            }
            fileInputStream.close();
        }
        catch (ClassCastException classCastException) {
            JOptionPane.showMessageDialog(null, ERROR_NOT_A_COMPOSITION_FACTORY);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, ERROR_CANNOT_LOAD_BEAN + exception.getMessage());
            exception.printStackTrace();
        }
        return compositionFactory;
    }
}

