/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ToneAdjustmentOp
implements BufferedImageOp {
    private static int[] gsToRGB = new int[256];
    private IndexColorModel colorModel;
    private boolean nullDestAsSource = false;
    public static final String USAGE = "java com.sun.glf.goodies.ToneAdjustmentOp <imageFileName>";

    public ToneAdjustmentOp(Color color) {
        this(new Color[]{Color.black, color, Color.white}, new float[]{1.0f, 1.0f}, true);
    }

    public ToneAdjustmentOp(Color color, Color color2, Color color3) {
        this(new Color[]{Color.black, color, color2, color3, Color.white}, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, true);
    }

    public ToneAdjustmentOp(Color[] colorArray, float[] fArray) {
        this(colorArray, fArray, false);
    }

    public ToneAdjustmentOp(Color[] colorArray, float[] fArray, boolean bl) {
        if (fArray == null || colorArray == null) {
            throw new IllegalArgumentException("tones and toneRanges should not be null");
        }
        if (fArray.length != colorArray.length - 1) {
            throw new IllegalArgumentException("tones length and toneRanges length to not match. tones should have one more elements than toneRanges");
        }
        this.nullDestAsSource = bl;
        Color[] colorArray2 = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, colorArray2, 0, colorArray.length);
        colorArray = colorArray2;
        for (int i = 0; i < colorArray.length; ++i) {
            if (colorArray[i] != null) continue;
            throw new IllegalArgumentException("Cannot use null tone value. Element " + i + " is null");
        }
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        float f = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            if (fArray2[i] < 0.0f) {
                throw new IllegalArgumentException("Cannot use negative intervals : " + i + " is " + fArray2[i]);
            }
            f += fArray2[i];
        }
        if (f == 0.0f) {
            throw new IllegalArgumentException("Interval ranges should not all be zero");
        }
        float f2 = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            int n = i;
            fArray2[n] = fArray2[n] / f;
            int n2 = i;
            fArray2[n2] = fArray2[n2] * 256.0f;
            fArray2[i] = (int)fArray2[i];
            f2 += fArray2[i];
        }
        if (f2 > 256.0f) {
            throw new Error("Internal error");
        }
        if (f2 < 256.0f) {
            int n = fArray2.length - 1;
            fArray2[n] = fArray2[n] + (256.0f - f2);
        }
        fArray = fArray2;
        int[] nArray = new int[256];
        int n = 0;
        int n3 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            int n4 = (int)fArray[i];
            n3 = n + n4;
            int n5 = colorArray[i].getRGB();
            int n6 = colorArray[i + 1].getRGB();
            int n7 = (n5 & 0xFF0000) >> 16;
            int n8 = (n5 & 0xFF00) >> 8;
            int n9 = n5 & 0xFF;
            int n10 = (n6 & 0xFF0000) >> 16;
            int n11 = (n6 & 0xFF00) >> 8;
            int n12 = n6 & 0xFF;
            float f3 = n10 - n7;
            float f4 = n11 - n8;
            float f5 = n12 - n9;
            if (n4 > 1) {
                f3 /= (float)(n4 - 1);
                f4 /= (float)(n4 - 1);
                f5 /= (float)(n4 - 1);
            }
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            for (int j = 0; j < n4; ++j) {
                n13 = n7 + (int)(f3 * (float)j);
                n14 = n8 + (int)(f4 * (float)j);
                n15 = n9 + (int)(f5 * (float)j);
                nArray[n + j] = 0xFF000000 | n13 << 16 | n14 << 8 | n15;
            }
            n = n3;
        }
        this.colorModel = new IndexColorModel(8, 256, nArray, 0, false, -1, 0);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D;
        BufferedImage bufferedImage3;
        if (bufferedImage == null) {
            throw new NullPointerException("src image is null");
        }
        BufferedImage bufferedImage4 = bufferedImage;
        if (bufferedImage.getType() != 10) {
            bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            bufferedImage = bufferedImage3;
        }
        bufferedImage3 = new BufferedImage(this.colorModel, bufferedImage.getRaster(), true, null);
        if (this.nullDestAsSource) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage4, null);
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = bufferedImage3;
        } else {
            graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2 = null;
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public static void main(String[] stringArray) {
        Color[][] colorArrayArray;
        Object object;
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        if (stringArray.length < 1) {
            bufferedImage = new BufferedImage(256, 20, 10);
            bufferedImage2 = new BufferedImage(256, 20, 1);
            object = bufferedImage.createGraphics();
            colorArrayArray = new GradientPaint(0.0f, 0.0f, Color.black, bufferedImage.getWidth(), 0.0f, Color.white);
            ((Graphics2D)object).setPaint((Paint)colorArrayArray);
            ((Graphics)object).fillRect(0, 0, 256, 20);
            object = bufferedImage2.createGraphics();
            ((Graphics2D)object).setPaint((Paint)colorArrayArray);
            ((Graphics)object).fillRect(0, 0, 256, 20);
        } else {
            object = stringArray[0];
            bufferedImage = Toolbox.loadImage((String)object, 10);
            bufferedImage2 = Toolbox.loadImage((String)object, 1);
            if (bufferedImage == null || bufferedImage2 == null) {
                throw new Error("Could not load : " + (String)object);
            }
        }
        BufferedImage bufferedImage3 = new BufferedImage(256, 20, 10);
        object = new ColorConvertOp(null);
        ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        colorArrayArray = new Color[][]{{Color.black, Color.white}, {Color.black, Color.red, Color.white}, {Color.black, Color.blue, Color.white}, {Color.black, new Color(128, 30, 30), Color.yellow, Color.white}, {Color.white, Color.black}};
        float[][] fArrayArray = new float[][]{{1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f}};
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Dimension dimension = new Dimension(n * 3, n2);
        LayerComposition layerComposition = new LayerComposition(dimension);
        Layer[] layerArray = new ImageLayer[]{new ImageLayer(layerComposition, bufferedImage, Position.TOP_LEFT), new ImageLayer(layerComposition, bufferedImage2, Position.TOP), new ImageLayer(layerComposition, bufferedImage3, Position.TOP_RIGHT)};
        layerComposition.setLayers(layerArray);
        jPanel.add(new CompositionComponent(layerComposition));
        for (int i = 0; i < colorArrayArray.length; ++i) {
            layerComposition = new LayerComposition(dimension);
            layerArray = new ImageLayer[]{new ImageLayer(layerComposition, bufferedImage, Position.TOP_LEFT), new ImageLayer(layerComposition, bufferedImage2, Position.TOP), new ImageLayer(layerComposition, bufferedImage3, Position.TOP_RIGHT)};
            ToneAdjustmentOp toneAdjustmentOp = new ToneAdjustmentOp(colorArrayArray[i], fArrayArray[i]);
            layerArray[0].setImageFilter(toneAdjustmentOp);
            layerArray[1].setImageFilter(toneAdjustmentOp);
            layerArray[2].setImageFilter(toneAdjustmentOp);
            layerComposition.setLayers(layerArray);
            jPanel.add(new CompositionComponent(layerComposition));
        }
        JFrame jFrame = new JFrame("ToneAdjustmentOp regression testing");
        jFrame.getContentPane().add(new JScrollPane(jPanel));
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    static {
        ColorSpace colorSpace = ICC_ColorSpace.getInstance(1003);
        for (int i = 0; i < 256; ++i) {
            float[] fArray = colorSpace.toRGB(new float[]{(float)i / 255.0f});
            ToneAdjustmentOp.gsToRGB[i] = (int)Math.rint(255.0f * fArray[0]);
        }
    }
}

