/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.goodies.ColorCompositeRule;
import com.sun.glf.util.TimeProbe;
import java.awt.Color;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class ColorCompositeContext
implements CompositeContext {
    private ColorCompositeRule rule;
    private float alpha;
    private ColorModel srcColorModel;
    private ColorModel dstColorModel;
    private ColorSpace srcColorSpace;
    private ColorSpace dstColorSpace;

    public ColorCompositeContext(ColorCompositeRule colorCompositeRule, float f, ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        if (colorCompositeRule == null || colorModel == null || colorModel2 == null) {
            throw new IllegalArgumentException("No argument should be null");
        }
        this.rule = colorCompositeRule;
        this.alpha = f;
        this.srcColorModel = colorModel;
        this.dstColorModel = colorModel2;
        this.srcColorSpace = colorModel.getColorSpace();
        this.dstColorSpace = colorModel2.getColorSpace();
    }

    public void dispose() {
    }

    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        if (raster.getWidth() != raster2.getWidth() || raster.getHeight() != raster2.getHeight() || raster.getMinX() != raster2.getMinX() || raster.getMinY() != raster2.getMinY()) {
            throw new Error("Incompatible sizes or origin for src and dstIn rasters");
        }
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        ColorModel colorModel = ColorModel.getRGBdefault();
        boolean bl2 = bl = !this.srcColorModel.equals(colorModel);
        if (bl) {
            System.out.println("Converting Source");
            WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n3, n4);
            object4 = new ColorConvertOp(this.srcColorSpace, colorModel.getColorSpace(), null);
            ((ColorConvertOp)object4).filter(raster, writableRaster2);
            raster = writableRaster2.createWritableTranslatedChild(n, n2);
        }
        boolean bl3 = !this.dstColorModel.equals(colorModel);
        object4 = writableRaster;
        if (bl3) {
            System.out.println("Converting Destination");
            object3 = colorModel.createCompatibleWritableRaster(n3, n4);
            object2 = new ColorConvertOp(this.dstColorSpace, colorModel.getColorSpace(), null);
            ((ColorConvertOp)object2).filter(raster2, (WritableRaster)object3);
            raster2 = ((WritableRaster)object3).createWritableTranslatedChild(n, n2);
            object = colorModel.createCompatibleWritableRaster(n3, n4);
            ((ColorConvertOp)object2).filter(writableRaster, (WritableRaster)object);
            writableRaster = ((WritableRaster)object).createWritableTranslatedChild(n, n2);
        }
        object3 = new TimeProbe();
        object2 = (DataBufferInt)raster.getDataBuffer();
        object = (DataBufferInt)raster2.getDataBuffer();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = ((DataBufferInt)object2).getBankData()[0];
        int[] nArray2 = ((DataBufferInt)object).getBankData()[0];
        int[] nArray3 = dataBufferInt.getBankData()[0];
        int n5 = ((DataBuffer)object2).getOffset();
        int n6 = ((DataBuffer)object).getOffset();
        int n7 = dataBufferInt.getOffset();
        int n8 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n9 = ((SinglePixelPackedSampleModel)raster2.getSampleModel()).getScanlineStride();
        int n10 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n11 = n8 - n3;
        int n12 = n9 - n3;
        int n13 = n10 - n3;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        float[] fArray = new float[3];
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        float[] fArray2 = new float[3];
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        float[] fArray3 = new float[3];
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int n28 = n5;
        int n29 = n6;
        int n30 = n7;
        int n31 = this.rule.toInt();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = this.alpha;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                n25 = nArray[n28];
                n26 = nArray2[n29];
                n17 = n25 >> 24 & 0xFF;
                n14 = n25 >> 16 & 0xFF;
                n15 = n25 >> 8 & 0xFF;
                n16 = n25 & 0xFF;
                n21 = n26 & 0xFF000000;
                n18 = n26 >> 16 & 0xFF;
                n19 = n26 >> 8 & 0xFF;
                n20 = n26 & 0xFF;
                Color.RGBtoHSB(n14, n15, n16, fArray);
                Color.RGBtoHSB(n18, n19, n20, fArray2);
                switch (n31) {
                    case 0: {
                        fArray3[0] = fArray[0];
                        fArray3[1] = fArray2[1];
                        fArray3[2] = fArray2[2];
                        break;
                    }
                    case 1: {
                        fArray3[0] = fArray2[0];
                        fArray3[1] = fArray[1];
                        fArray3[2] = fArray2[2];
                        break;
                    }
                    case 2: {
                        fArray3[0] = fArray2[0];
                        fArray3[1] = fArray2[1];
                        fArray3[2] = fArray[2];
                        break;
                    }
                    case 3: {
                        fArray3[0] = fArray[0];
                        fArray3[1] = fArray[1];
                        fArray3[2] = fArray2[2];
                        break;
                    }
                    default: {
                        throw new Error("Unknown ColorCompositeRule: " + this.rule);
                    }
                }
                n27 = Color.HSBtoRGB(fArray3[0], fArray3[1], fArray3[2]);
                n22 = (n27 & 0xFF0000) >> 16;
                n23 = (n27 & 0xFF00) >> 8;
                n24 = n27 & 0xFF;
                f = f3 * (float)n17 / 255.0f;
                f2 = 1.0f - f;
                n22 = (int)(f * (float)n22 + f2 * (float)n18);
                n23 = (int)(f * (float)n23 + f2 * (float)n19);
                n24 = (int)(f * (float)n24 + f2 * (float)n20);
                n27 = n22 << 16 & 0xFF0000 | n23 << 8 & 0xFF00 | n24;
                nArray3[n30] = n27 |= n21;
                ++n28;
                ++n29;
                ++n30;
            }
            n28 += n11;
            n29 += n12;
            n30 += n13;
        }
        if (bl3) {
            System.out.println("Converting Destination");
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorModel.getColorSpace(), this.dstColorSpace, null);
            colorConvertOp.filter(writableRaster, (WritableRaster)object4);
        }
    }
}

