###################################################
### chunk number 1: library
###################################################
#line 56 "EBImage-introduction.Rnw"
library("EBImage")


###################################################
### chunk number 2: display-hack
###################################################
#line 59 "EBImage-introduction.Rnw"
display = function(...) if (interactive()) EBImage::display(...)


###################################################
### chunk number 3: readImage1
###################################################
#line 67 "EBImage-introduction.Rnw"
f = system.file("images", "lena.gif", package="EBImage")
lena = readImage(f)


###################################################
### chunk number 4: display
###################################################
#line 74 "EBImage-introduction.Rnw"
display(lena)


###################################################
### chunk number 5: readImage2
###################################################
#line 88 "EBImage-introduction.Rnw"
lenac = readImage(system.file("images", "lena-color.png", package="EBImage"))
display(lenac)
nuc = readImage(system.file('images', 'nuclei.tif', package='EBImage'))
display(nuc)


###################################################
### chunk number 6: readImage2h
###################################################
#line 94 "EBImage-introduction.Rnw"
writeImage(nuc, 'nuc.jpeg', quality=85)


###################################################
### chunk number 7: writeImage
###################################################
#line 112 "EBImage-introduction.Rnw"
writeImage(lena,  'lena.jpeg', quality=85)
writeImage(lenac, 'lenac.jpeg', quality=85)


###################################################
### chunk number 8: print
###################################################
#line 126 "EBImage-introduction.Rnw"
print(lena)


###################################################
### chunk number 9: math1
###################################################
#line 135 "EBImage-introduction.Rnw"
lena1 = lena+0.5
lena2 = 3*lena
lena3 = (0.2+lena)^3


###################################################
### chunk number 10: math1h
###################################################
#line 140 "EBImage-introduction.Rnw"
writeImage(lena1, 'lena1.jpeg', quality=85)
writeImage(lena2, 'lena2.jpeg', quality=85)
writeImage(lena3, 'lena3.jpeg', quality=85)


###################################################
### chunk number 11: math2
###################################################
#line 159 "EBImage-introduction.Rnw"
lena4 = lena[299:376, 224:301]
lena5 = lena>0.5
lena6 = t(lena)
print(median(lena))


###################################################
### chunk number 12: math2h
###################################################
#line 165 "EBImage-introduction.Rnw"
writeImage(lena4, 'lena4.jpeg', quality=85)
writeImage(lena5, 'lena5.png')
writeImage(lena6, 'lena6.jpeg', quality=85)


###################################################
### chunk number 13: combine
###################################################
#line 182 "EBImage-introduction.Rnw"
lenacomb = combine(lena, lena*2, lena*3, lena*4)
display(lenacomb)


###################################################
### chunk number 14: combineh
###################################################
#line 186 "EBImage-introduction.Rnw"
writeImage(lenacomb, 'lenacomb.jpeg', quality=85)


###################################################
### chunk number 15: spatial
###################################################
#line 208 "EBImage-introduction.Rnw"
lena7 = rotate(lena, 30)
lena8 = translate(lena, c(40, 70))
lena9 = flip(lena)


###################################################
### chunk number 16: spatialh
###################################################
#line 213 "EBImage-introduction.Rnw"
writeImage(lena7, 'lena7.jpeg', quality=85)
writeImage(lena8, 'lena8.jpeg', quality=85)
writeImage(lena9, 'lena9.jpeg', quality=85)


###################################################
### chunk number 17: print
###################################################
#line 240 "EBImage-introduction.Rnw"
print(lenac)


###################################################
### chunk number 18: colorMode
###################################################
#line 252 "EBImage-introduction.Rnw"
colorMode(lenac) = Grayscale
display(lenac)


###################################################
### chunk number 19: colorModeh
###################################################
#line 256 "EBImage-introduction.Rnw"
writeImage(lenac, 'lenac.jpeg', quality=85)


###################################################
### chunk number 20: colorMode2
###################################################
#line 271 "EBImage-introduction.Rnw"
colorMode(lenac) = Color


###################################################
### chunk number 21: channel
###################################################
#line 281 "EBImage-introduction.Rnw"
lenak = channel(lena, 'rgb')
lenak[236:276, 106:146, 1] = 1
lenak[236:276, 156:196, 2] = 1
lenak[236:276, 206:246, 3] = 1
lenab = rgbImage(red=lena, green=flip(lena), blue=flop(lena))


###################################################
### chunk number 22: channelh
###################################################
#line 288 "EBImage-introduction.Rnw"
writeImage(lenak, 'lenak.jpeg', quality=85)
writeImage(lenab, 'lenab.jpeg', quality=85)


###################################################
### chunk number 23: filter
###################################################
#line 311 "EBImage-introduction.Rnw"
flo = makeBrush(21, shape='disc', step=FALSE)^2
flo = flo/sum(flo)
lenaflo = filter2(lenac, flo)

fhi =  matrix(1, nc=3, nr=3)
fhi[2,2] = -8
lenafhi = filter2(lenac, fhi)


###################################################
### chunk number 24: filterh
###################################################
#line 320 "EBImage-introduction.Rnw"
writeImage(lenaflo, 'lenaflo.jpeg', quality=85)
writeImage(lenafhi, 'lenafhi.jpeg', quality=85)


###################################################
### chunk number 25: drawtext
###################################################
#line 338 "EBImage-introduction.Rnw"
font = drawfont(weight=600, size=28)
lenatext = drawtext(lena, xy=c(250, 450), labels="Lena", font=font, col="white")


###################################################
### chunk number 26: filterh
###################################################
#line 342 "EBImage-introduction.Rnw"
writeImage(lenatext, 'lenatext.jpeg', quality=85)


###################################################
### chunk number 27: morpho
###################################################
#line 361 "EBImage-introduction.Rnw"
ei = readImage(system.file('images', 'shapes.png', package='EBImage'))
ei = ei[110:512,1:130]
display(ei)

kern = makeBrush(5, shape='diamond')
eierode = erode(ei, kern)
eidilat = dilate(ei, kern)


###################################################
### chunk number 28: morphoh
###################################################
#line 370 "EBImage-introduction.Rnw"
writeImage(ei, 'ei.png')
writeImage(kern, 'kern.png')
writeImage(eierode, 'eierode.png')
writeImage(eidilat, 'eidilat.png')


###################################################
### chunk number 29: segmentation
###################################################
#line 395 "EBImage-introduction.Rnw"
eilabel = bwlabel(ei)
cat('Number of objects=', max(eilabel),'\n')

nuct = nuc[,,1]>0.2
nuclabel = bwlabel(nuct)
cat('Number of nuclei=', max(nuclabel),'\n')


###################################################
### chunk number 30: segmentationh
###################################################
#line 403 "EBImage-introduction.Rnw"
writeImage(eilabel/max(eilabel), 'eilabel.png')
writeImage(nuclabel/max(nuclabel), 'nuclabel.png')


###################################################
### chunk number 31: segmentation2
###################################################
#line 440 "EBImage-introduction.Rnw"
nuct2 =  thresh(nuc[,,1], 10, 10, 0.05)
kern = makeBrush(5, shape='disc')
nuct2 = dilate(erode(nuct2, kern), kern)
nuclabel2 = bwlabel(nuct2)
cat('Number of nuclei=', max(nuclabel2),'\n')


###################################################
### chunk number 32: segmentation2h
###################################################
#line 447 "EBImage-introduction.Rnw"
writeImage(nuclabel2/max(nuclabel2), 'nuclabel2.png')


###################################################
### chunk number 33: manip
###################################################
#line 468 "EBImage-introduction.Rnw"
nucgray = channel(nuc[,,1], 'rgb')
nuch1 = paintObjects(nuclabel2, nucgray, col='#ff00ff')
nuclabel3 = fillHull(nuclabel2)
nuch2 = paintObjects(nuclabel3, nucgray, col='#ff00ff')


###################################################
### chunk number 34: maniph
###################################################
#line 474 "EBImage-introduction.Rnw"
writeImage(nuch1, 'nuch1.jpeg', quality=85)
writeImage(nuch2, 'nuch2.jpeg', quality=85)


###################################################
### chunk number 35: manip2
###################################################
#line 492 "EBImage-introduction.Rnw"
xy = hullFeatures(nuclabel3)[, c('g.x', 'g.y')]
font = drawfont(weight=600, size=16)
nuctext = drawtext(nuch2, xy=xy, labels=as.character(1:nrow(xy)), font=font, col="yellow")


###################################################
### chunk number 36: manip2h
###################################################
#line 497 "EBImage-introduction.Rnw"
writeImage(nuctext, 'nuctext.jpeg', quality=85)


###################################################
### chunk number 37: cs1
###################################################
#line 518 "EBImage-introduction.Rnw"
nuc = readImage(system.file('images', 'nuclei.tif', package='EBImage'))
cel = readImage(system.file('images', 'cells.tif', package='EBImage'))
img = rgbImage(green=1.5*cel, blue=nuc)


###################################################
### chunk number 38: cs1h
###################################################
#line 523 "EBImage-introduction.Rnw"
writeImage(cel, 'cel.jpeg', quality=85)
writeImage(img, 'img.jpeg', quality=85)


###################################################
### chunk number 39: cs2
###################################################
#line 561 "EBImage-introduction.Rnw"
nmask = thresh(nuc, 10, 10, 0.05)
nmask = opening(nmask, makeBrush(5, shape='disc'))
nmask = fillHull(nmask)
nmask = bwlabel(nmask)


###################################################
### chunk number 40: cs2h
###################################################
#line 567 "EBImage-introduction.Rnw"
writeImage(nmask/max(nmask), 'nmask.png')


###################################################
### chunk number 41: cs3
###################################################
#line 582 "EBImage-introduction.Rnw"
ctmask = opening(cel>0.1, makeBrush(5, shape='disc'))
cmask = propagate(cel, nmask, ctmask)


###################################################
### chunk number 42: cs3h
###################################################
#line 586 "EBImage-introduction.Rnw"
writeImage(cmask/max(cmask), 'cmask.png')


###################################################
### chunk number 43: cs4
###################################################
#line 603 "EBImage-introduction.Rnw"
res = paintObjects(cmask, img, col='#ff00ff')
res = paintObjects(nmask, res, col='#ffff00')
xy = lapply(hullFeatures(cmask), function(hf) hf[, c('g.x', 'g.y')])
labels = lapply(xy, function(z) as.character(1:nrow(z)))
font = drawfont(weight=600, size=16)
res = drawtext(res, xy=xy, labels=labels , font=font, col="white")


###################################################
### chunk number 44: cs4h
###################################################
#line 611 "EBImage-introduction.Rnw"
writeImage(res, 'res.jpeg', quality=85)


