###################################################
### chunk number 1: load libraries
###################################################
#line 50 "Clonality.Rnw"
library(DNAcopy)
library(Clonality)
library(gdata)


###################################################
### chunk number 2: read data
###################################################
#line 58 "Clonality.Rnw"
data<-read.xls("http://waldman.ucsf.edu/Breast/Hwang.data.xls")
data<-data[!is.na(data[,2]),]
data<-data[apply(is.na(data),1,sum)<=50,]
data<-data[,apply(is.na(data),2,sum)<=1000] 


###################################################
### chunk number 3: 
###################################################
#line 65 "Clonality.Rnw"
data[1:5,1:10]


###################################################
### chunk number 4: prep data
###################################################
#line 73 "Clonality.Rnw"
arrayinfo<-read.xls("http://waldman.ucsf.edu/Colon/nakao.data.xls")  #needed to extract  genomic locations
data$Position<-arrayinfo$Mb[match(toupper(as.character(data[,1])),toupper(as.character(arrayinfo[,1])))]
data<-data[!is.na(data$Position),]


###################################################
### chunk number 5: remove repeated maplocs
###################################################
#line 81 "Clonality.Rnw"
length(unique(paste(data$Chromosome, data$Position))) #there are repeated genomic locations
data<-data[c(TRUE,data$Position[-1]!=data$Position[-1864]),] #discard probes with repeated genomic locations
data<-data[data$Chromosome<=22,] #getting rid of X and Y chromosomes


###################################################
### chunk number 6: 
###################################################
#line 87 "Clonality.Rnw"
dim(data)


###################################################
### chunk number 7: CNA
###################################################
#line 93 "Clonality.Rnw"
dataCNA<-CNA(as.matrix(data[,c(4:6,28:30)]),maploc=data$Position,chrom=data$Chromosome,sampleid=names(data)[c(4:6,28:30)]) #taking the first 3 patients only to shorten the computation time; use c(4:51) for the full dataset


###################################################
### chunk number 8: averaging
###################################################
#line 102 "Clonality.Rnw"
dataAve<- ave.adj.probes(dataCNA,2)


###################################################
### chunk number 9: split chromosomes
###################################################
#line 111 "Clonality.Rnw"
dataCNA$maploc<-dataCNA$maploc*1000 #transforming maploc to Kb scale
dataCNA$chrom<- splitChromosomes(dataCNA$chrom,dataCNA$maploc)  #splits the chromosomes into arms


###################################################
### chunk number 10: 
###################################################
#line 118 "Clonality.Rnw"
ptlist<-substr(names(dataCNA)[-c(1,2)],1,4)


###################################################
### chunk number 11: main clonality analysis
###################################################
#line 123 "Clonality.Rnw"
results<-clonality.analysis(dataCNA, ptlist,   nmad = 1.25,  reference = TRUE, allpairs = FALSE)


###################################################
### chunk number 12: 
###################################################
#line 128 "Clonality.Rnw"
results$LR


###################################################
### chunk number 13: genomewidePlots
###################################################
#line 137 "Clonality.Rnw"
genomewidePlots(results$OneStepSeg, results$ChromClass,ptlist , c("LC03LCIS", "LC03ILC"),results$LR,  plot.as.in.analysis = TRUE) 


###################################################
### chunk number 14: 
###################################################
#line 148 "Clonality.Rnw"
histogramPlot(results$LR[,4], results$refLR[,4])


###################################################
### chunk number 15: LOH data generation
###################################################
#line 187 "Clonality.Rnw"
set.seed(25)
LOHtable<-cbind(1:20,matrix(sample(c(0,1,2),20*20,replace=TRUE),20))
LOHtable[,3]<-LOHtable[,2]
LOHtable[1,3]<-0


###################################################
### chunk number 16: LOH data analysis
###################################################
#line 194 "Clonality.Rnw"
LOHtable[,1:5]
LOHclonality(LOHtable,rep(1:10,each=2),pfreq=NULL,noloh=0,loh1=1,loh2=2)


###################################################
### chunk number 17: sessionInfo
###################################################
#line 204 "Clonality.Rnw"
sessionInfo()


