###################################################
### chunk number 1: 
###################################################
#line 58 "ChromHeatMap.Rnw"
library('ALL')
data('ALL')
selSamples <- ALL$mol.biol %in% c('ALL1/AF4', 'E2A/PBX1')
ALLs <- ALL[, selSamples]

library('ChromHeatMap')
chrdata<-makeChrStrandData(exprs(ALLs), lib='hgu95av2')


###################################################
### chunk number 2: 
###################################################
#line 88 "ChromHeatMap.Rnw"
groupcol <- ifelse( ALLs$mol.biol == 'ALL1/AF4', 'red', 'green' )
plotChrMap(chrdata, 19, strands='both', RowSideColors=groupcol)


###################################################
### chunk number 3: 
###################################################
#line 99 "ChromHeatMap.Rnw"
plotmap<-plotChrMap(chrdata, 1, cytoband='q23', interval=50000, srtCyto=0, cexCyto=1.2)


###################################################
### chunk number 4:  eval=FALSE
###################################################
## #line 136 "ChromHeatMap.Rnw"
## probes <- grabChrMapProbes( plotmap )
## genes <- unlist(mget(probes, envir=hgu95av2SYMBOL, ifnotfound=NA))


###################################################
### chunk number 5: 
###################################################
#line 157 "ChromHeatMap.Rnw"
sessionInfo()


