###################################################
### chunk number 1: distances
###################################################
#line 52 "Introduction.Rnw"
	set.seed(1)
	dist <- sample(c(170:300, 400), 10100, prob=c(dnbinom(0:130, mu=30, size=5), 0.2), replace=TRUE)
	pos <- cumsum(dist)
	pos <- pos[pos < 2e6 - 200]


###################################################
### chunk number 2: readPos1
###################################################
#line 74 "Introduction.Rnw"
	fwdRegion <- unlist(lapply(pos, function(x) (x-88):(x-68)))
	revRegion <- unlist(lapply(pos, function(x) (x+68):(x+88)))


###################################################
### chunk number 3: readPos2
###################################################
#line 80 "Introduction.Rnw"
	fwd <- sample(fwdRegion, 5e4, replace=TRUE)
	rev <- sample(revRegion, 5e4, replace=TRUE)


###################################################
### chunk number 4: readPos3
###################################################
#line 86 "Introduction.Rnw"
	fwd <- c(fwd, sample(25:(2e6-25), 2e5, replace=TRUE))
	rev <- c(rev, sample(25:(2e6-25), 2e5, replace=TRUE))


###################################################
### chunk number 5: formatData
###################################################
#line 94 "Introduction.Rnw"
	reads <- data.frame(chromosome="chr1", position=c(fwd, rev), length=25, 
			strand=rep(c("+", "-"), each=250000))


###################################################
### chunk number 6: library
###################################################
#line 100 "Introduction.Rnw"
	library(ChIPseqR)


###################################################
### chunk number 7: simple
###################################################
#line 113 "Introduction.Rnw"
	counts <- strandPileup(reads, chrLen=2e6, extend=1, plot=FALSE)
	nucs <- simpleNucCall(counts, bind=147, support=15, plot=FALSE)


###################################################
### chunk number 8: plotNucPrint eval=FALSE
###################################################
## #line 128 "Introduction.Rnw"
## 	plot(nucs, type="density")
## 	plot(nucs, type="qqplot")


###################################################
### chunk number 9: plotNuc
###################################################
#line 134 "Introduction.Rnw"
	par(mfrow=c(1,2))
	plot(nucs, type="density")
	plot(nucs, type="qqplot")


###################################################
### chunk number 10: plotWindowPrint eval=FALSE
###################################################
## #line 151 "Introduction.Rnw"
## 	predicted <- peaks(nucs)[[1]][911]
## 	plot(counts, chr="chr1", center=predicted, score=nucs, width=1000, type="window")


###################################################
### chunk number 11: plotWindowPrint2 eval=FALSE
###################################################
## #line 158 "Introduction.Rnw"
## 	abline(v=pos[pos < predicted + 1000 & pos > predicted - 1000], col=3, lty=3)


###################################################
### chunk number 12: plotWindow
###################################################
#line 163 "Introduction.Rnw"
	predicted <- peaks(nucs)[[1]][911]
	plot(counts, chr="chr1", center=predicted, score=nucs, width=1000, type="window")
	abline(v=pos[pos < predicted + 1000 & pos > predicted - 1000], col=3, lty=3)


###################################################
### chunk number 13: noOver
###################################################
#line 177 "Introduction.Rnw"
	calls <- peaks(nucs)[[1]][c(1,which(diff(peaks(nucs)[[1]]) >= 170)+1)]
	length(calls)


###################################################
### chunk number 14: spec
###################################################
#line 182 "Introduction.Rnw"
	table(sapply(calls, function(x) any((x-20):(x+20) %in% pos)))


###################################################
### chunk number 15: getBindLen
###################################################
#line 224 "Introduction.Rnw"
	bLen <- getBindLen(counts, bind = c(100,200), support = c(5, 50))


###################################################
### chunk number 16: getBindLenPrint eval=FALSE
###################################################
## #line 230 "Introduction.Rnw"
## 	bLen <- getBindLen(counts, bind = c(100,200), support = c(5, 50))


###################################################
### chunk number 17: decompress
###################################################
#line 298 "Introduction.Rnw"
	counts2 <- decompress(counts)


###################################################
### chunk number 18: sessionInfo
###################################################
#line 320 "Introduction.Rnw"
	sessionInfo()


