### R code from vignette source 'ChIPpeakAnno.Rnw'

###################################################
### code chunk number 1: ChIPpeakAnno.Rnw:35-40
###################################################
library(ChIPpeakAnno)
data(myPeakList)
data(TSS.human.NCBI36)
annotatedPeak = annotatePeakInBatch(myPeakList[1:6,], AnnotationData=TSS.human.NCBI36)
as.data.frame(annotatedPeak)


###################################################
### code chunk number 2: ChIPpeakAnno.Rnw:52-59
###################################################
myPeak1 = RangedData(IRanges(start=c(967654, 2010897, 2496704, 3075869, 3123260 ,3857501,201089,1543200,1557200,1563000,1569800,167889600), end= c(967754, 2010997, 2496804, 3075969, 3123360 ,3857601,201089,1555199,1560599,1565199,1573799,167893599),names=c("Site1", "Site2", "Site3", "Site4", "Site5", "Site6", "Site7","Site8","Site9","Site10","Site11","Site12")), space=c("1", "2", "3", "4", "5", "6","2","6","6","6","6","5"))

TFbindingSites = RangedData(IRanges(start=c(967659, 2010898, 2496700, 3075866, 3123260 ,3857500, 96765, 201089, 249670, 307586, 312326 ,385750,1549800,1554400,1565000,1569400,167888600), end=c(967869, 2011108, 2496920,3076166,3123470,3857780, 96985, 201299, 249890, 307796,312586,385960,1550599,1560799,1565399,1571199,167888999), names=c("t1", "t2", "t3", "t4", "t5", "t6","t7", "t8", "t9", "t10", "t11", "t12","t13","t14","t15","t16","t17")), space=c("1", "2", "3", "4", "5", "6","1", "2", "3", "4", "5", "6","6","6","6","6","5"), strand=
c(1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,1,1,1,1,1))
annotatedPeak2 = annotatePeakInBatch(myPeak1, AnnotationData=TFbindingSites)
pie(table(as.data.frame(annotatedPeak2)$insideFeature))
as.data.frame(annotatedPeak2)


###################################################
### code chunk number 3: ChIPpeakAnno.Rnw:72-79
###################################################
peaks1 = RangedData(IRanges(start=c(967654, 2010897, 2496704, 3075869, 3123260 ,3857501,201089,1543200,1557200,1563000,1569800,167889600), end= c(967754, 2010997, 2496804, 3075969, 3123360 ,3857601,201089,1555199,1560599,1565199,1573799,167893599),names=c("Site1", "Site2", "Site3", "Site4", "Site5", "Site6", "Site7","Site8","Site9","Site10","Site11","Site12")), space=c("1", "2", "3", "4", "5", "6","2","6","6","6","6","5"),strand=as.integer(1))

peaks2 = RangedData(IRanges(start=c(967659, 2010898, 2496700, 3075866, 3123260 ,3857500, 96765, 201089, 249670, 307586, 312326 ,385750,1549800,1554400,1565000,1569400,167888600), end=c(967869, 2011108, 2496920,3076166,3123470,3857780, 96985, 201299, 249890, 307796,312586,385960,1550599,1560799,1565399,1571199,167888999), names=c("t1", "t2", "t3", "t4", "t5", "t6","t7", "t8", "t9", "t10", "t11", "t12","t13","t14","t15","t16","t17")), space=c("1", "2", "3", "4", "5", "6","1", "2", "3", "4", "5", "6","6","6","6","6","5"), strand=
c(1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,1,1,1,1,1))

t1 =findOverlappingPeaks(peaks1, peaks2, maxgap=1000, multiple=F, NameOfPeaks1="TF1", NameOfPeaks2="TF2") 



###################################################
### code chunk number 4: ChIPpeakAnno.Rnw:85-88
###################################################
overlappingPeaks = t1$OverlappingPeaks
overlappingPeaks
pie(table(overlappingPeaks$overlapFeature))


###################################################
### code chunk number 5: ChIPpeakAnno.Rnw:93-94
###################################################
as.data.frame(t1$MergedPeaks)


###################################################
### code chunk number 6: ChIPpeakAnno.Rnw:101-102
###################################################
as.data.frame(t1$Peaks1withOverlaps)


###################################################
### code chunk number 7: ChIPpeakAnno.Rnw:109-110
###################################################
as.data.frame(t1$Peaks2withOverlaps)


###################################################
### code chunk number 8: ChIPpeakAnno.Rnw:115-119
###################################################
peaks3 = RangedData(IRanges(start=c(967859, 2010868, 2496500, 3075966, 3123460 ,3851500, 96865, 201189, 249600, 307386), end=c(967969, 2011908, 2496720,3076166,3123470,3857680, 96985, 201299, 249890, 307796), names=c("p1", "p2", "p3", "p4", "p5", "p6","p7", "p8", "p9", "p10")), space=c("1", "2", "3", "4", "5", "6","1", "2", "3", "4"), strand=
c(1,1,1,1,1,1,-1,-1,-1,-1))

findOverlappingPeaks(findOverlappingPeaks(peaks1, peaks2, maxgap=1000, multiple=F,NameOfPeaks1="TF1", NameOfPeaks2="TF2")$Peaks1withOverlap, peaks3, maxgap=1000, multiple=F, NameOfPeaks1="TF1TF2", NameOfPeaks2="TF3")$Peaks1withOverlap


###################################################
### code chunk number 9: ChIPpeakAnno.Rnw:125-126
###################################################
makeVennDiagram(RangedDataList(peaks1, peaks2), NameOfPeaks=c("TF1", "TF2"), maxgap=0, totalTest=100, cex = 1, counts.col = "red")


###################################################
### code chunk number 10: ChIPpeakAnno.Rnw:135-139
###################################################
peaks = RangedData(IRanges(start=c(100, 500), end=c(300, 600), names=c("peak1", "peak2")), space=c("NC_008253", "NC_010468"))
library(BSgenome.Ecoli.NCBI.20080805)
peaksWithSequences = getAllPeakSequence(peaks, upstream = 20,
	downstream = 20, genome = Ecoli)


###################################################
### code chunk number 11: ChIPpeakAnno.Rnw:146-147
###################################################
write2FASTA(peaksWithSequences)


###################################################
### code chunk number 12: ChIPpeakAnno.Rnw:170-171
###################################################
data(enrichedGO)


###################################################
### code chunk number 13: ChIPpeakAnno.Rnw:177-178
###################################################
enrichedGO$bp[1:6,]


###################################################
### code chunk number 14: ChIPpeakAnno.Rnw:185-186
###################################################
enrichedGO$mf[1:6,]


###################################################
### code chunk number 15: ChIPpeakAnno.Rnw:193-194
###################################################
enrichedGO$cc


###################################################
### code chunk number 16: ChIPpeakAnno.Rnw:211-212
###################################################
sessionInfo()


