###################################################
### chunk number 1: setup
###################################################
#line 27 "CSAR.Rnw"
options(width=60)
options(continue=" ")
options(prompt="R> ")


###################################################
### chunk number 2: loadData
###################################################
#line 52 "CSAR.Rnw"
library(CSAR)
data("CSAR-dataset");
head(sampleSEP3_test)
head(controlSEP3_test)
nhitsS<-mappedReads2Nhits(sampleSEP3_test,file="sampleSEP3_test",chr=c("CHR1v01212004"),chrL=c(10000))
nhitsC<-mappedReads2Nhits(controlSEP3_test,file="controlSEP3_test",chr=c("CHR1v01212004"),chrL=c(10000))
nhitsC$filenames
nhitsS$filenames


###################################################
### chunk number 3: runScore
###################################################
#line 69 "CSAR.Rnw"
test<-ChIPseqScore(control=nhitsC,sample=nhitsS,file="test",times=10000)
test$filenames
win<-sigWin(test)
head(win)
score2wig(test,file="test.wig",times=10000)
d<-distance2Genes(win=win,gff=TAIR8_genes_test)
head(d)
genes<-genesWithPeaks(d)
head(genes)


###################################################
### chunk number 4: runPermutation
###################################################
#line 84 "CSAR.Rnw"
permutatedWinScores(nn=1,sample=sampleSEP3_test,control=controlSEP3_test,fileOutput="test",chr=c("CHR1v01212004"),chrL=c(100000))
permutatedWinScores(nn=2,sample=sampleSEP3_test,control=controlSEP3_test,fileOutput="test",chr=c("CHR1v01212004"),chrL=c(100000))
nulldist<-getPermutatedWinScores(file="test",nn=1:2)
getThreshold(winscores=win$score,permutatedScores=nulldist,FDR=.05)


###################################################
### chunk number 5: 
###################################################
#line 98 "CSAR.Rnw"
sessionInfo()


