###################################################
### chunk number 1: CGHnormaliterPackage
###################################################
#line 13 "CGHnormaliter.Rnw"
options(keep.source=TRUE)
CGHnormaliterPackage <- packageDescription("CGHnormaliter")


###################################################
### chunk number 2: loadData
###################################################
#line 85 "CGHnormaliter.Rnw"
library(CGHnormaliter)
data(Leukemia)


###################################################
### chunk number 3: runCGHnormaliter
###################################################
#line 93 "CGHnormaliter.Rnw"
result <- CGHnormaliter(Leukemia, nchrom=4, cellularity=0.9)


###################################################
### chunk number 4: accessResults
###################################################
#line 119 "CGHnormaliter.Rnw"
normalized.data <- copynumber(result)  # log2 ratios
segmented.data <- segmented(result)
called.data <- calls(result)


###################################################
### chunk number 5: densityPlotCommand
###################################################
#line 131 "CGHnormaliter.Rnw"
plot(density(normalized.data[, 2]), col=1, xlab="log2 ratio",
                                    main="Density plot")
abline(v=0, lty=2)



###################################################
### chunk number 6: densityPlotFigure
###################################################
#line 140 "CGHnormaliter.Rnw"
#line 131 "CGHnormaliter.Rnw"
plot(density(normalized.data[, 2]), col=1, xlab="log2 ratio",
                                    main="Density plot")
abline(v=0, lty=2)

#line 141 "CGHnormaliter.Rnw"


###################################################
### chunk number 7: callPlotCommand
###################################################
#line 157 "CGHnormaliter.Rnw"
plot(result[,2], ylimit=c(-2,2), dotres=1)


###################################################
### chunk number 8: callPlotFigure
###################################################
#line 163 "CGHnormaliter.Rnw"
#line 157 "CGHnormaliter.Rnw"
plot(result[,2], ylimit=c(-2,2), dotres=1)
#line 164 "CGHnormaliter.Rnw"


###################################################
### chunk number 9: saveNormalizedData
###################################################
#line 179 "CGHnormaliter.Rnw"
CGHnormaliter.write.table(result)


###################################################
### chunk number 10: saveOtherData
###################################################
#line 186 "CGHnormaliter.Rnw"
CGHnormaliter.write.table(result, data.type="segmented")
CGHnormaliter.write.table(result, data.type="called")


