###################################################
### chunk number 1: load
###################################################
#line 119 "BCRANK.Rnw"
library(BCRANK) 


###################################################
### chunk number 2: loadFasta
###################################################
#line 126 "BCRANK.Rnw"
fastaFile <- system.file("Exfiles/USF1_small.fa", package="BCRANK")


###################################################
### chunk number 3: loadResult
###################################################
#line 138 "BCRANK.Rnw"
data(BCRANKout)


###################################################
### chunk number 4: viewBCRANKresult
###################################################
#line 146 "BCRANK.Rnw"
BCRANKout


###################################################
### chunk number 5: viewTopMotif
###################################################
#line 154 "BCRANK.Rnw"
topMotif <- toptable(BCRANKout,1)
topMotif


###################################################
### chunk number 6: viewWM
###################################################
#line 161 "BCRANK.Rnw"
weightMatrix <- pwm(topMotif, normalize=FALSE)
weightMatrix


###################################################
### chunk number 7: fig1
###################################################
#line 169 "BCRANK.Rnw"
weightMatrixNormalized <- pwm(topMotif, normalize=TRUE)
library(seqLogo)
seqLogo(weightMatrixNormalized)


###################################################
### chunk number 8: fig2
###################################################
#line 180 "BCRANK.Rnw"
plot(topMotif)


###################################################
### chunk number 9: reportSites
###################################################
#line 189 "BCRANK.Rnw"
topConsensus <- as.character(toptable(BCRANKout)[1,"Consensus"])
print(topConsensus)
bindingSites <- matchingSites(fastaFile,topConsensus)
nrSites <- nrow(bindingSites)
cat("Number predicted binding sites:",nrSites,"\n")
print(bindingSites[1:15,])


