###################################################
### chunk number 1: 
###################################################
#line 56 "ArrayTools.Rnw"
library(ArrayTools)
data(exprsExample)
head(exprsExample)
dim(exprsExample)
data(pDataExample)
pDataExample


###################################################
### chunk number 2: 
###################################################
#line 71 "ArrayTools.Rnw"
rownames(exprsExample) <- exprsExample$probeset_id
eSet <- createExpressionSet (pData=pDataExample,  exprs = exprsExample, annotation = "hugene10sttranscriptcluster")
dim(eSet)


###################################################
### chunk number 3: 
###################################################
#line 91 "ArrayTools.Rnw"
normal <- preProcessGeneST (eSet, output=TRUE)
normal
dim(normal)


###################################################
### chunk number 4: 
###################################################
#line 111 "ArrayTools.Rnw"
data(QC)
qaGeneST(normal, c("Treatment", "Group"), QC)


###################################################
### chunk number 5: 
###################################################
#line 130 "ArrayTools.Rnw"
filtered <- geneFilter(normal, numChip = 2, bg = 4, iqrPct=0.1,  output=TRUE)


###################################################
### chunk number 6: 
###################################################
#line 145 "ArrayTools.Rnw"
design1<- new("designMatrix", target=pData(filtered), covariates = "Treatment")
design1


###################################################
### chunk number 7: 
###################################################
#line 152 "ArrayTools.Rnw"
design2<- new("designMatrix", target=pData(filtered), covariates = c("Treatment", "Group"))
design2


###################################################
### chunk number 8: 
###################################################
#line 162 "ArrayTools.Rnw"
contrast1 <- new("contrastMatrix", design.matrix = design1,  compare1 = "Treated", compare2 = "Control")
contrast1


###################################################
### chunk number 9: 
###################################################
#line 170 "ArrayTools.Rnw"
contrast2 <- new("contrastMatrix", design.matrix = design2, compare1 = "Treated", compare2 = "Control")
contrast2


###################################################
### chunk number 10: 
###################################################
#line 180 "ArrayTools.Rnw"
result1 <- regress(filtered, contrast1)
result2 <- regress(filtered, contrast2)


###################################################
### chunk number 11: 
###################################################
#line 191 "ArrayTools.Rnw"
sigResult1 <- selectSigGene(result1, p.value=0.05, fc.value=log2(1.5))
sigResult2 <- selectSigGene(result2, p.value=0.05, fc.value=log2(1.5))


###################################################
### chunk number 12: 
###################################################
#line 201 "ArrayTools.Rnw"
Sort(sigResult1, sorted.by = 'pValue')
Sort(sigResult2, sorted.by = 'F')


###################################################
### chunk number 13: 
###################################################
#line 211 "ArrayTools.Rnw"
Output2HTML(sigResult1)
Output2HTML(sigResult2)


###################################################
### chunk number 14: 
###################################################
#line 225 "ArrayTools.Rnw"
designInt <- new("designMatrix", target=pData(filtered), covariates = c("Treatment", "Group"), intIndex=c(1,2))
designInt
contrastInt <- new("contrastMatrix", design.matrix = designInt, interaction = TRUE)
contrastInt


###################################################
### chunk number 15: 
###################################################
#line 235 "ArrayTools.Rnw"
resultInt <- regress(filtered, contrastInt)
sigResultInt <-selectSigGene(resultInt, p.value=0.05, fc.value=log2(1.5))


###################################################
### chunk number 16: 
###################################################
#line 253 "ArrayTools.Rnw"
intResult <- postInteraction(filtered, sigResultInt, mainVar ="Treatment",  compare1 = "Treated",  compare2 = "Control")
sigResultInt <- selectSigGeneInt(intResult, pGroup = 0.05, pMain = 0.05)


###################################################
### chunk number 17: 
###################################################
#line 262 "ArrayTools.Rnw"
Output2HTML(sigResultInt)


###################################################
### chunk number 18: 
###################################################
#line 271 "ArrayTools.Rnw"
createIndex (sigResult1, sigResult2, intResult)


