###################################################
### chunk number 1: 
###################################################
#line 39 "AnnotationFuncsUserguide.Rnw"
library(org.Bt.eg.db)
genes <- c('280705', '280706', '100327208')
symbols <- org.Bt.egSYMBOL[genes]
toTable(symbols)


###################################################
### chunk number 2: 
###################################################
#line 56 "AnnotationFuncsUserguide.Rnw"
symbols <- c('BCSE','TF','TG')
entrez <- org.Bt.egSYMBOL2EG[symbols]
entrez <- toTable(entrez)[,'gene_id']
entrez
refseq <- org.Bt.egREFSEQ[entrez]
toTable(refseq)


###################################################
### chunk number 3: 
###################################################
#line 72 "AnnotationFuncsUserguide.Rnw"
library(AnnotationFuncs)
translate(c(280705, 280706, 100327208, 123), org.Bt.egSYMBOL)
translate(c('BCSE','TF','TG'), from=org.Bt.egSYMBOL2EG, to=org.Bt.egREFSEQ)


###################################################
### chunk number 4: 
###################################################
#line 102 "AnnotationFuncsUserguide.Rnw"
library(AnnotationFuncs)
library(org.Bt.eg.db)
genes <- c(280705, 280706, 100327208)
translate(genes, org.Bt.egGENENAME)
translate(genes, org.Bt.egCHR)
translate(genes, org.Bt.egENSEMBL)
translate(genes, org.Bt.egREFSEQ, remove.missing=FALSE)


###################################################
### chunk number 5: 
###################################################
#line 116 "AnnotationFuncsUserguide.Rnw"
symbols <- c("SERPINA1","KERA","CD5")
translate(symbols, org.Bt.egSYMBOL2EG)
translate(symbols, revmap(org.Bt.egSYMBOL))


###################################################
### chunk number 6: 
###################################################
#line 125 "AnnotationFuncsUserguide.Rnw"
translate(symbols, from=org.Bt.egSYMBOL2EG, to=org.Bt.egGENENAME)
# As a curiosity, if you specify another organism, you are warned:
library(org.Hs.eg.db)
translate(symbols, from=org.Bt.egSYMBOL2EG, to=org.Hs.egGENENAME)
warnings()


###################################################
### chunk number 7: 
###################################################
#line 137 "AnnotationFuncsUserguide.Rnw"
symbols <- c("SERPINA1","KERA","CD5")
translate(symbols, org.Bt.egSYMBOL2EG, org.Bt.egREFSEQ)
translate(symbols, org.Bt.egSYMBOL2EG, org.Bt.egREFSEQ, reduce='first')
translate(symbols, org.Bt.egSYMBOL2EG, org.Bt.egREFSEQ, reduce='last')


###################################################
### chunk number 8: 
###################################################
#line 146 "AnnotationFuncsUserguide.Rnw"
translate(symbols, org.Bt.egSYMBOL2EG, org.Bt.egREFSEQ, return.list=FALSE)


###################################################
### chunk number 9: 
###################################################
#line 153 "AnnotationFuncsUserguide.Rnw"
groups <- list('a'=c('ACR','ASM','S','KERA'), 'IL'=c('IL1','IL2','IL3','IL10'), 'bwahh'=c('ACR','SERPINA1','IL1','IL10','CD5'))


###################################################
### chunk number 10: 
###################################################
#line 158 "AnnotationFuncsUserguide.Rnw"
lapply(groups, translate, from=org.Bt.egSYMBOL2EG, simplify=TRUE)


###################################################
### chunk number 11: 
###################################################
#line 164 "AnnotationFuncsUserguide.Rnw"
symbols <- unlist(groups, use.names=FALSE)
ent <- translate(symbols, org.Bt.egSYMBOL2EG)
ent
mapLists(groups, ent)


###################################################
### chunk number 12: 
###################################################
#line 188 "AnnotationFuncsUserguide.Rnw"
symbols <- c("SERPINA1","KERA","CD5")
refseq <- translate(symbols, from=org.Bt.egSYMBOL2EG, to=org.Bt.egREFSEQ)
mRNA <- pickRefSeq(refseq, priorities=c('NM','XM'))	# Equals pickRefSeq.mRNA
mRNA
proteins <- pickRefSeq(refseq, priorities=c('NP','XP')) # Equals pickRefSeq.Protein
proteins


###################################################
### chunk number 13:  eval=FALSE
###################################################
## #line 206 "AnnotationFuncsUserguide.Rnw"
## symbols <- c("SERPINA1","KERA","CD5")
## GOs <- translate(symbols, from=org.Bt.egSYMBOL2EG, to=org.Bt.egGO)
## # Pick biological process:
## pickGO(GOs, category='BP')
## # Pick only those biological processes for Entrez Gene ID 280730
## # which have been inferred from sequence similarity or electronic annotation:
## pickGO(translate(280730, org.Bt.egGO), category='BP', evidence=c('ISS','IEA'))


###################################################
### chunk number 14: 
###################################################
#line 233 "AnnotationFuncsUserguide.Rnw"
library(hom.Hs.inp.db)
submap <- hom.Hs.inpBOSTA[c('ENSP00000356224','ENSP00000384582','ENSP00000364403')]
toTable(submap)


###################################################
### chunk number 15: 
###################################################
#line 260 "AnnotationFuncsUserguide.Rnw"
getOrthologs(c('ENSP00000356224','ENSP00000384582','ENSP00000364403'), hom.Hs.inpBOSTA, 'BOSTA')


###################################################
### chunk number 16: 
###################################################
#line 269 "AnnotationFuncsUserguide.Rnw"
symbols <- c("SERPINA1","KERA","CD5")
getOrthologs(symbols, hom.Hs.inpBOSTA, 'BOSTA', pre.from=org.Hs.egSYMBOL2EG, pre.to=org.Hs.egENSEMBLPROT, post.from=org.Bt.egENSEMBLPROT2EG, post.to=org.Bt.egSYMBOL)


###################################################
### chunk number 17: 
###################################################
#line 288 "AnnotationFuncsUserguide.Rnw"
sessionInfo()


