###################################################
### chunk number 1: 
###################################################
#line 55 "AffyExpress.Rnw"
library(AffyExpress)
library(estrogen)
datadir <- system.file("extdata", package = "estrogen")
phenoD<-read.AnnotatedDataFrame("phenoData.txt", path=datadir, sep="", header=TRUE, row.names="filename")
raw<-ReadAffy(filenames=rownames(pData(phenoD)), phenoData= phenoD, celfile.path=datadir)
pData(raw)


###################################################
### chunk number 2: 
###################################################
#line 70 "AffyExpress.Rnw"
AffyQA (parameters=c("estrogen", "time.h"), raw=raw) 


###################################################
### chunk number 3: 
###################################################
#line 87 "AffyExpress.Rnw"
normaldata<-pre.process(method="rma", raw=raw) 
dims(normaldata) 


###################################################
### chunk number 4: 
###################################################
#line 94 "AffyExpress.Rnw"
filtered<-Filter(object=normaldata, numChip=2, bg=6) 


###################################################
### chunk number 5: 
###################################################
#line 125 "AffyExpress.Rnw"
design<-make.design(target=pData(filtered), cov="estrogen") 
design


###################################################
### chunk number 6: 
###################################################
#line 147 "AffyExpress.Rnw"
contrast<-make.contrast(design.matrix=design, compare1="present",
compare2="absent") 
contrast 


###################################################
### chunk number 7: 
###################################################
#line 166 "AffyExpress.Rnw"
result<-regress(object=filtered, design=design, contrast=contrast, method="L", adj="fdr") 


###################################################
### chunk number 8: 
###################################################
#line 170 "AffyExpress.Rnw"
result[1:3,] 


###################################################
### chunk number 9: 
###################################################
#line 177 "AffyExpress.Rnw"
select<-select.sig.gene(top.table=result, p.value=0.05, m.value=log2(1.5)) 


###################################################
### chunk number 10: 
###################################################
#line 189 "AffyExpress.Rnw"
result2html(cdf.name=annotation(filtered), result=select, filename="singleFactor") 


###################################################
### chunk number 11: 
###################################################
#line 203 "AffyExpress.Rnw"
result.wrapper<-AffyRegress(normal.data=filtered, cov="estrogen", compare1="present",
compare2="absent", method="L", adj="fdr", p.value=0.05, m.value=log2(1.5))


###################################################
### chunk number 12: 
###################################################
#line 220 "AffyExpress.Rnw"
design.rb<-make.design(target=pData(filtered), cov=c("estrogen", "time.h")) 
design.rb


###################################################
### chunk number 13: 
###################################################
#line 234 "AffyExpress.Rnw"
contrast.rb<-make.contrast(design.matrix=design.rb, compare1="present", compare2="absent") 
contrast.rb 


###################################################
### chunk number 14: 
###################################################
#line 261 "AffyExpress.Rnw"
design.int<-make.design(pData(filtered), cov=c("estrogen", "time.h"), int=c(1,2)) 
design.int


###################################################
### chunk number 15: 
###################################################
#line 267 "AffyExpress.Rnw"
contrast.10<-make.contrast(design.matrix=design.int, compare1 ="present", compare2="absent", level="10") 
contrast.10


###################################################
### chunk number 16: 
###################################################
#line 272 "AffyExpress.Rnw"
contrast.48<-make.contrast(design.matrix=design.int, compare1 ="present", compare2="absent", level="48") 
contrast.48


###################################################
### chunk number 17: 
###################################################
#line 295 "AffyExpress.Rnw"
contrast.int<-make.contrast(design.int, interaction=TRUE)
contrast.int 


###################################################
### chunk number 18: 
###################################################
#line 303 "AffyExpress.Rnw"
result.int<-regress(object=filtered, design=design.int, contrast=contrast.int, method="L") 


###################################################
### chunk number 19: 
###################################################
#line 311 "AffyExpress.Rnw"
select.int<-select.sig.gene(result.int, m.value=log2(1.5), p.value=0.05)


###################################################
### chunk number 20: 
###################################################
#line 317 "AffyExpress.Rnw"
sig.ID<-select.int$ID[select.int$significant==TRUE]
sig.index<-match(sig.ID, rownames(exprs(filtered))) 


###################################################
### chunk number 21: 
###################################################
#line 333 "AffyExpress.Rnw"
result2<-post.interaction(strata.var="time.h",compare1="present", compare2="absent", design.int=design.int, 
    object=filtered[sig.index,], method="L",adj="fdr", p.value=0.05, m.value=log2(1.5))


###################################################
### chunk number 22: 
###################################################
#line 346 "AffyExpress.Rnw"
interaction.result2html(cdf.name=annotation(filtered), result=result2, inter.result=result.int)


###################################################
### chunk number 23: 
###################################################
#line 355 "AffyExpress.Rnw"
result1<-regress(object=filtered[-sig.index,], design=design, contrast=contrast, method="L", adj="fdr") 
select<-select.sig.gene(top.table=result1, p.value=0.05, m.value=log2(1.5)) 


###################################################
### chunk number 24: 
###################################################
#line 367 "AffyExpress.Rnw"
result3<-AffyInteraction(object=filtered, method="L", main.var="estrogen", 
strata.var = "time.h", compare1="present", compare2="absent", p.int=0.05, m.int=log2(1.5), 
adj.int="none", p.value=0.05, m.value=log2(1.5), adj="fdr")


