###################################################
### chunk number 1: setup
###################################################
#line 40 "MAGEAndARR.Rnw"
library(AffyCompatible)


###################################################
### chunk number 2: arr-examples
###################################################
#line 48 "MAGEAndARR.Rnw"
arrDir <- system.file("extdata", "ARR", package="AffyCompatible")
arrFiles <- list.files(arrDir, pattern=".*ARR", full=TRUE)
basename(arrFiles)


###################################################
### chunk number 3: readArr
###################################################
#line 56 "MAGEAndARR.Rnw"
arr <- readArr(arrFiles[[1]])
arrs <- sapply(arrFiles, readArr)
arrs[[1]]


###################################################
### chunk number 4: arr-accessors
###################################################
#line 69 "MAGEAndARR.Rnw"
guid(arr)
version(arr)


###################################################
### chunk number 5: physicalArrays-accessor
###################################################
#line 79 "MAGEAndARR.Rnw"
physicalArrays(arr)
pas <- physicalArrays(arr)[[1]]
pas


###################################################
### chunk number 6: physicalArray-accessor
###################################################
#line 89 "MAGEAndARR.Rnw"
physicalArray(pas)[[1]]


###################################################
### chunk number 7: userAttribute
###################################################
#line 95 "MAGEAndARR.Rnw"
ua <- userAttribute(userAttributes(arr)[[1]])
ua


###################################################
### chunk number 8: userAttribute-access
###################################################
#line 102 "MAGEAndARR.Rnw"
lapply(ua[1:4], force)
sapply(ua[1:4], name)


###################################################
### chunk number 9: ARR-readXml
###################################################
#line 110 "MAGEAndARR.Rnw"
xml <- readXml(arrFiles[[1]])


###################################################
### chunk number 10: xclass-ARR
###################################################
#line 117 "MAGEAndARR.Rnw"
xclass(xml, "/ArraySetFile")
xclass(xml, "/ArraySetFile/UserAttributes/UserAttribute[4]")


###################################################
### chunk number 11: xclass-abbrev-ARR
###################################################
#line 125 "MAGEAndARR.Rnw"
xclass(xml, "//UserAttribute[4]")
sapply(xclass(xml, "//UserAttribute"), name)[1:4]


###################################################
### chunk number 12: xpath-query
###################################################
#line 137 "MAGEAndARR.Rnw"
AffyCompatible:::.xreserved()
unlist(xpathApply(xml, "//UserAttribute/@Name", xmlValue))


###################################################
### chunk number 13: mage-examples
###################################################
#line 146 "MAGEAndARR.Rnw"
mageDir <- system.file("extdata", "DTT", package="AffyCompatible")
mageFiles <- list.files(mageDir, pattern=".*xml", full=TRUE)
basename(mageFiles)


###################################################
### chunk number 14: readMage
###################################################
#line 154 "MAGEAndARR.Rnw"
mage <- readMage(mageFiles[[1]])
mages <- sapply(mageFiles, readMage)
mages[[1]]


###################################################
### chunk number 15: mage-accessors
###################################################
#line 162 "MAGEAndARR.Rnw"
ba <- bioAssay_assnlist(bioAssay_package(mage)[[1]])[[1]]
ba
measuredBioAssay(ba)[[1]]


###################################################
### chunk number 16: mage-readXml
###################################################
#line 170 "MAGEAndARR.Rnw"
xml <- readXml(mageFiles[[1]])
xclass(xml, "//MeasuredBioAssay")[[1]]
sapply(xclass(xml, "//Protocol/*/Parameter"), name)[1:10]
xpathApply(xml, "//MeasuredBioAssay/@name", xmlValue)


###################################################
### chunk number 17: mage-hardware-xml
###################################################
#line 180 "MAGEAndARR.Rnw"
hq <- "//Hybridization/*/ProtocolApplication/*/HardwareApplication/*/ParameterValue"
hval <- xpathApply(xml, paste(hq, "/@value"), xmlValue)
names(hval) <- xpathApply(xml, paste(hq, "//@identifier"), xmlValue)
hval


###################################################
### chunk number 18: dtd
###################################################
#line 191 "MAGEAndARR.Rnw"
dtdDir <- system.file("extdata", package="AffyCompatible")
list.files(dtdDir, pattern=".*dtd")


