#!/bin/sh

set -e  # Exit immediately if a simple command exits with a non-zero status

echo "Number of records (all numbers should be the same):"
grep -E '^rs' "$1" | wc -l
grep '| human | 9606 |' "$1" | wc -l
grep -E '^SNP \| alleles=' "$1" | wc -l
grep -E '^VAL \| validated=' "$1" | wc -l

echo "validated=YES vs validated=NO (the sum should be = nb of records):"
grep -E '^VAL \| validated=YES' "$1" | wc -l
grep -E '^VAL \| validated=NO' "$1" | wc -l

echo "Number of reported locations in reference genome (should be >= nb of records):"
grep -E '^CTG \| assembly=GRCh37 \| chr=' "$1" | wc -l
