###################################################
### chunk number 1: setup
###################################################
#line 47 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
par(mfrow=c(1,1))


###################################################
### chunk number 2: importData
###################################################
#line 50 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
library(prada)
sampdat <- readFCS(system.file("extdata", "fas-Bcl2-plate323-04-04.A01", 
                               package="prada"))
fdat    <- exprs(sampdat)


###################################################
### chunk number 3: plotsbefore
###################################################
#line 59 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
plot(fdat[,"FSC-H"], fdat[,"SSC-H"], pch=20, col="#303030", 
     xlab="FSC", ylab="SSC", main="Scatter plot FSC vs SSC")


###################################################
### chunk number 4: plotNorm2
###################################################
#line 93 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
nfit <- fitNorm2(fdat[,"FSC-H"], fdat[,"SSC-H"], scalefac=2)


###################################################
### chunk number 5: plotNorm2-1
###################################################
#line 102 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
plotNorm2(nfit, selection=TRUE, ellipse=TRUE)


###################################################
### chunk number 6: plotNorm2-2
###################################################
#line 114 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
nfit3 <- fitNorm2(fdat[,"FSC-H"], fdat[,"SSC-H"], scalefac=3)
plotNorm2(nfit3, selection=TRUE, ellipse=TRUE)


###################################################
### chunk number 7: indexing
###################################################
#line 123 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
cleanfdat <- fdat[nfit$sel,]


###################################################
### chunk number 8: plotafter
###################################################
#line 128 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
par(mfrow=c(1,2))
xlim <- range(fdat[,"FL1-H"])
ylim <- range(fdat[,"FL4-H"])
plot(fdat[,"FL1-H"], fdat[,"FL4-H"], pch=20, col="#303030", xlab="FL1", 
     ylab="FL4", main="all data", xlim=xlim, ylim=ylim)
plot(cleanfdat[,"FL1-H"], cleanfdat[,"FL4-H"], pch=20, col="#303030", xlab="FL1", 
     ylab="FL4", main="clean data only", xlim=xlim, ylim=ylim)


###################################################
### chunk number 9: smoothscatter
###################################################
#line 149 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpkkTzcZ/R.INSTALL2cff5902/prada/inst/doc/norm2.Rnw"
smoothScatter(fdat[,c("FSC-H", "SSC-H")], nrpoints=50) 


