###################################################
### chunk number 1: 
###################################################
#line 77 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
set.seed(1)
options(width=65)


###################################################
### chunk number 2: loadData
###################################################
#line 101 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
library(les)
library(Biobase)
data(simTile)
treatment <- as.factor(phenoData(simTile)$condition == "treatment")
pos <- featureData(simTile)$position
exprs <- exprs(simTile)
regions <- c(100, 150, 600, 650)
cols <- rep(c("lightblue3", "lightgreen"), each=2)


###################################################
### chunk number 3: plotExpressionValues
###################################################
#line 116 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
matplot(exprs, pch=".", xlab="Probe position", ylab="Expression")
abline(v=regions, col=cols)


###################################################
### chunk number 4: estimateProbeLevelStatistics
###################################################
#line 132 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
library(limma)
design <- cbind(mean=1, diff=treatment)
fit <- lmFit(exprs, design)
fit <- eBayes(fit)
pval <- as.numeric(fit$p.value[, "diff"])


###################################################
### chunk number 5: plotProbeLevelStatistics
###################################################
#line 142 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
plot(pos, pval, pch=".", xlab="Probe position", ylab="P-value")
abline(v=regions, col=cols)


###################################################
### chunk number 6: constructLes
###################################################
#line 177 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
res <- Les(pos, pval)


###################################################
### chunk number 7: estimateLes
###################################################
#line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
win <- 30
res <- estimate(res, win)


###################################################
### chunk number 8: showPlotLes
###################################################
#line 206 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
res
plot(res)
abline(v=regions, col=cols)


###################################################
### chunk number 9: estimateLes2
###################################################
#line 217 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
win2 <- 50
res <- estimate(res, win2)


###################################################
### chunk number 10: showPlotLes2
###################################################
#line 224 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
res
plot(res)
abline(v=regions, col=cols)


###################################################
### chunk number 11: threshold
###################################################
#line 247 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
res <- threshold(res, grenander=TRUE, verbose=TRUE)


###################################################
### chunk number 12: regions
###################################################
#line 262 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
theta <- 0.3
res <- regions(res, limit=theta, verbose=TRUE)
res
res["regions"]


###################################################
### chunk number 13: plotRegions
###################################################
#line 271 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
region <- res["regions"]
borders <- c(region$start, region$end)
plot(res)
abline(v=regions, col=cols)
abline(v=borders, col="darkgray", lty=2)


###################################################
### chunk number 14: ci
###################################################
#line 291 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
subset <- pos >= 580 & pos <= 670
res <- ci(res, subset, nBoot=50)


###################################################
### chunk number 15: plotCi
###################################################
#line 298 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
plot(res, error="ci", limit=theta, xlim=c(580, 670))


###################################################
### chunk number 16: plotOptions
###################################################
#line 317 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
plot(res, error="ci", region=TRUE, rug=TRUE, rugSide=3, main="LES for simulated data", probePch="*", probeCol="blue", errorCol="lightgray", regionCol="lightgreen", xlim=c(580, 670) , ylim=c(0, 0.8), limit=FALSE, lty=0)


###################################################
### chunk number 17: customWeightingFunction
###################################################
#line 343 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
weightFoo <- function(distance, win) {
weight <- 1 - distance/win
return(weight)
}
res2 <- estimate(res, 20, weighting=weightFoo)


###################################################
### chunk number 18: sessionInfo
###################################################
#line 360 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZWah73/R.INSTALL750c2dda/les/inst/doc/les.Rnw"
toLatex(sessionInfo(), locale=FALSE)


