###################################################
### chunk number 1: init
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
display = function(...) {invisible()}


###################################################
### chunk number 2: library
###################################################
#line 92 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
library('imageHTS')


###################################################
### chunk number 3: parseImageConf
###################################################
#line 95 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
localPath = tempdir()
serverURL = system.file('submorph', package='imageHTS')
x = parseImageConf('conf/imageconf.txt', localPath=localPath, serverURL=serverURL)


###################################################
### chunk number 4: configure
###################################################
#line 110 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
x = configure(x, 'conf/description.txt', 'conf/plateconf.txt', 'conf/screenlog.txt')
x = annotate(x, 'conf/annotation.txt')


###################################################
### chunk number 5: getUnames
###################################################
#line 121 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
unames = setdiff(getUnames(x), getUnames(x, content='empty'))
unames 


###################################################
### chunk number 6: getWellFeatures
###################################################
#line 130 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
getWellFeatures(x, unames[1:3])


###################################################
### chunk number 7: segmentWells1
###################################################
#line 159 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
uname = getUnames(x, content='rluc')[3]
print(uname)
y =  segmentWells(x, uname=uname, segmentationPar='conf/segmentationpar.txt')
display(y$cal)
hseg = highlightSegmentation(0.6*y$cal, y$nseg, y$cseg, thick=TRUE)
display(hseg)


###################################################
### chunk number 8: segmentWells1h
###################################################
#line 167 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
writeImage(y$cal, 'cal.jpeg', quality=80)
writeImage(hseg, 'hseg.jpeg', quality=80)


###################################################
### chunk number 9: segmentWells2 eval=FALSE
###################################################
## #line 193 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
## unames = setdiff(getUnames(x), getUnames(x, content='empty'))
## segmentWells(x, unames, 'conf/segmentationpar.txt')


###################################################
### chunk number 10: fileHTS
###################################################
#line 206 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
fileHTS(x, type='source', uname=uname, channel=1)
fileHTS(x, type='seg', uname=uname)
fileHTS(x, type='viewfull', uname=uname)        


###################################################
### chunk number 11: extractFeatures
###################################################
#line 224 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
extractFeatures(x, uname, 'conf/featurepar.txt')


###################################################
### chunk number 12: readFeatures
###################################################
#line 234 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
y = readHTS(x, type='ftrs', uname=uname, format='tab')
dim(y)
y[1:10, 1:7]


###################################################
### chunk number 13: histfig
###################################################
#line 250 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
hist(y$c.t.m.int, 20, xlab='Cell tubulin intensity (a.u.)', main='')
abline(v=1600, col=2)
cellid = which(y$c.t.m.int>1600)
print(cellid)


###################################################
### chunk number 14: traceCell
###################################################
#line 269 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
cal = readHTS(x, type='cal', uname=uname, format='rda')
seg = readHTS(x, type='seg', uname=uname, format='rda')
cseg = rmObjects(seg$cseg, setdiff(1:nrow(y), cellid))
hightub = highlightSegmentation(0.6*cal, cseg=cseg, thick=TRUE)
display(hightub)


###################################################
### chunk number 15: traceCellh
###################################################
#line 276 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
writeImage(hightub, 'hightub.jpeg', quality=80)


###################################################
### chunk number 16: readLearnTS eval=FALSE
###################################################
## #line 306 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
## readLearnTS(x, 'conf/featurepar.txt', 'conf/trainingset.txt')


###################################################
### chunk number 17: predictCellLabels
###################################################
#line 317 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
predictCellLabels(x, uname)


###################################################
### chunk number 18: drawCellLabels
###################################################
#line 324 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
clab = readHTS(x, type='clabels', uname=uname, format='tab')
labid = split(1:nrow(clab), clab$label)
inter = seg$cseg%in%labid$I
mito = seg$cseg%in%labid$M
debris = seg$cseg%in%labid$D
dc = Image(c(inter+mito, inter, debris+inter), colormode='Color', dim=c(dim(seg$cseg)[1:2], 3))
dc = highlightSegmentation(0.5*dc+0.2*drop(cal), cseg=seg$cseg, thick=TRUE)
display(dc)


###################################################
### chunk number 19: drawCellLabelsh
###################################################
#line 334 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
writeImage(dc, 'dc.jpeg', quality=80)


###################################################
### chunk number 20: summarizeWells eval=FALSE
###################################################
## #line 362 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
## summarizeWells(x, unames, 'conf/featurepar.txt')


###################################################
### chunk number 21: sum
###################################################
#line 371 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
profiles = readHTS(x, type='file', filename='data/profiles.tab', format='tab')
wfcontent = factor(as.character(getWellFeatures(x, unames)$controlStatus))
table(wfcontent)
zwf = split(1:nrow(profiles), wfcontent)
ft = c('n', 'med.c.g.s', 'med.c.t.m.int', 'M', 'D')
avef = do.call(rbind, lapply(zwf, function(z) colMeans(profiles[z, ft])))
print(avef)


###################################################
### chunk number 22: imageconf
###################################################
#line 397 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
f = fileHTS(x, 'file', filename='conf/imageconf.txt')
cat(paste(readLines(f), collapse='\n'), '\n')


###################################################
### chunk number 23: segmentationpar
###################################################
#line 402 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
f = fileHTS(x, 'file', filename='conf/segmentationpar.txt')
cat(paste(readLines(f), collapse='\n'), '\n')


###################################################
### chunk number 24: featurepar
###################################################
#line 407 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
f = fileHTS(x, 'file', filename='conf/featurepar.txt')
cat(paste(readLines(f), collapse='\n'), '\n')


###################################################
### chunk number 25: script eval=FALSE
###################################################
## #line 416 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
## library('imageHTS')
## localPath = tempdir()
## serverURL = system.file('submorph', package='imageHTS')
## x = parseImageConf('conf/imageconf.txt', localPath=localPath, serverURL=serverURL)
## x = configure(x, 'conf/description.txt', 'conf/plateconf.txt', 'conf/screenlog.txt')
## x = annotate(x, 'conf/annotation.txt')
## unames = setdiff(getUnames(x), getUnames(x, content='empty'))
## segmentWells(x, unames, 'conf/segmentationpar.txt')
## extractFeatures(x, unames, 'conf/featurepar.txt')
## readLearnTS(x, 'conf/featurepar.txt', 'conf/trainingset.txt')
## predictCellLabels(x, unames)
## summarizeWells(x, unames, 'conf/featurepar.txt')


###################################################
### chunk number 26: init
###################################################
#line 449 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
localPath = file.path(tempdir(), 'kimorph')
serverURL = 'http://www.ebi.ac.uk/~gpau/imageHTS/screens/kimorph'
x = parseImageConf('conf/imageconf.txt', localPath=localPath, serverURL=serverURL)
x = configure(x, 'conf/description.txt', 'conf/plateconf.txt', 'conf/screenlog.txt')
x = annotate(x, 'conf/annotation.txt')


###################################################
### chunk number 27: get
###################################################
#line 466 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
us = setdiff(getUnames(x), getUnames(x, content='empty'))
wfcontent = getWellFeatures(x, us)$controlStatus
table(wfcontent)
xd = readHTS(x, 'file', filename='data/profiles.tab', format='tab')
xd = xd[match(us, xd$uname),]


###################################################
### chunk number 28: boxplots
###################################################
#line 479 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
colors = c('#ffffff', NA, '#aaffff', '#ffaaff', '#ff44aa',  '#aaaaff',  '#aaffaa', 
  '#ff7777', '#aaaaaa', '#ffff77')
par(mfrow=c(1,2))
boxplot(xd$med.c.g.ss~wfcontent, las=2, col=colors, main='Median cell size (a.u.)')
boxplot(xd$med.c.g.ec~wfcontent, las=2, col=colors, main='Median cell eccentricity (a.u.)')


###################################################
### chunk number 29: lda1
###################################################
#line 503 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
library(MASS)
z = wfcontent %in% c('rluc', 'ubc', 'trappc3')
ft = 14:50
ld = lda(xd[z, ft], as.character(wfcontent[z]))
py = predict(ld, xd[, ft])
plot(py$x[,1:2])


###################################################
### chunk number 30: standout
###################################################
#line 524 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
unames = us[which(py$x[,1]>500)]
print(unames)
f = fileHTS(x, type='viewunmonted', spot=3, uname=unames[1])
img1 = readImage(f)[1791:2238,1:448,]
display(img1)
f = fileHTS(x, type='viewunmonted', spot=1, uname=unames[2])
img2 = readImage(f)[1:448,1:448,]
display(img2)


###################################################
### chunk number 31: standouth
###################################################
#line 534 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
writeImage(img1, 'img1.jpeg', quality=80)
writeImage(img2, 'img2.jpeg', quality=80)


###################################################
### chunk number 32: lda2
###################################################
#line 552 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
plot(py$x[,1:2], xlim=c(-35,25), ylim=c(-20,20), cex=0.3)
z = wfcontent!='sample'
points(py$x[z,1:2], col=1, bg=colors[wfcontent[z]], pch=21)
col = rep(1, length(levels(wfcontent)))
col[2] = NA
legend('topleft', legend=levels(wfcontent), col=col, pt.bg=colors[1:length(wfcontent)],
       pch=21, ncol=2, cex=0.8) 


###################################################
### chunk number 33: popCellPicker eval=FALSE
###################################################
## #line 585 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
## popWebQuery(x)
## uname = getUnames(x, content='trappc3')[1]
## popCellPicker(x, uname)


###################################################
### chunk number 34: sessionInfo
###################################################
#line 604 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprQ3CHL/R.INSTALL1c5359eb/imageHTS/inst/doc/imageHTS-introduction.Rnw"
toLatex(sessionInfo())


