###################################################
### chunk number 1: load_library
###################################################
#line 39 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
library(goseq)


###################################################
### chunk number 2: set_width
###################################################
#line 42 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
options(width=84)


###################################################
### chunk number 3: read.data eval=FALSE
###################################################
## #line 61 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## gene.vector=as.integer(assayed.genes%in%de.genes)
## names(gene.vector)=assayed.genes
## head(gene.vector)


###################################################
### chunk number 4: supported_genomes eval=FALSE
###################################################
## #line 82 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## supportedGenomes()


###################################################
### chunk number 5: supported_geneids eval=FALSE
###################################################
## #line 86 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## supportedGeneIDs()


###################################################
### chunk number 6: edger_1
###################################################
#line 131 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
library(edgeR)
table.summary=read.table(system.file("extdata","Li_sum.txt",package='goseq'),sep='\t',header=TRUE,stringsAsFactors=FALSE)
counts=table.summary[,-1]
rownames(counts)=table.summary[,1]
grp=factor(rep(c("Control","Treated"),times=c(4,3)))
summarized=DGEList(counts,lib.size=colSums(counts),group=grp)


###################################################
### chunk number 7: edger_2
###################################################
#line 142 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
disp=estimateCommonDisp(summarized)
disp$common.dispersion
tested=exactTest(disp)
topTags(tested)


###################################################
### chunk number 8: edger_3
###################################################
#line 151 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
genes=as.integer(p.adjust(tested$table$p.value[tested$table$logFC!=0],method="BH")<.05)
names(genes)=row.names(tested$table[tested$table$logFC!=0,])
table(genes)


###################################################
### chunk number 9: head_genomes
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
head(supportedGenomes())


###################################################
### chunk number 10: head_geneids
###################################################
#line 167 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
head(supportedGeneIDs(),n=12)


###################################################
### chunk number 11: pwf
###################################################
#line 179 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
pwf=nullp(genes,"hg18","ensGene")
head(pwf)


###################################################
### chunk number 12: GO.wall
###################################################
#line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
GO.wall=goseq(pwf,"hg18","ensGene")
head(GO.wall)


###################################################
### chunk number 13: GO.samp
###################################################
#line 206 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
GO.samp=goseq(pwf,"hg18","ensGene",method="Sampling",repcnt=1000)


###################################################
### chunk number 14: head_samp
###################################################
#line 209 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
head(GO.samp)


###################################################
### chunk number 15: plot_wal_v_samp
###################################################
#line 215 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
plot(log10(GO.wall[,2]), log10(GO.samp[match(GO.samp[,1],GO.wall[,1]),2]), xlab="log10(Wallenius p-values)", ylab="log10(Sampling p-values)", xlim=c(-3,0))
abline(0,1,col=3,lty=2)


###################################################
### chunk number 16: GO.nobias
###################################################
#line 226 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
GO.nobias=goseq(pwf,"hg18","ensGene",method="Hypergeometric")
head(GO.nobias)


###################################################
### chunk number 17: plot_wal_v_hyper
###################################################
#line 233 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
plot(log10(GO.wall[,2]), log10(GO.nobias[match(GO.nobias[,1],GO.wall[,1]),2]), xlab="log10(Wallenius p-values)", ylab="log10(Hypergeometric p-values)", xlim=c(-3,0), ylim=c(-3,0))
abline(0,1,col=3,lty=2)


###################################################
### chunk number 18: GO.limited
###################################################
#line 242 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
GO.MF=goseq(pwf,"hg18","ensGene",test.cats=c("GO:MF"))
head(GO.MF)


###################################################
### chunk number 19: enriched_GO
###################################################
#line 253 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
enriched.GO=GO.wall$category[p.adjust(GO.wall$over_represented_pvalue,method="BH")<.05]
head(enriched.GO)


###################################################
### chunk number 20: GO_explained
###################################################
#line 260 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
library(GO.db)
for(go in enriched.GO[1:10]){
	print(GOTERM[[go]])
	cat("--------------------------------------\n")
}


###################################################
### chunk number 21: getlength
###################################################
#line 273 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
len=getlength(names(genes),"hg18","ensGene")
length(len)
length(genes)
head(len)


###################################################
### chunk number 22: getgo
###################################################
#line 282 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
go=getgo(names(genes),"hg18","ensGene")
length(go)
length(genes)
head(go)


###################################################
### chunk number 23: conv_table
###################################################
#line 291 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
goseq:::.ID_MAP
goseq:::.ORG_PACKAGES


###################################################
### chunk number 24: norm_analysis eval=FALSE
###################################################
## #line 298 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## pwf=nullp(genes,"hg18","ensGene")
## go=goseq(pwf,"hg18","ensGene")


###################################################
### chunk number 25: verbose_analysis eval=FALSE
###################################################
## #line 303 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## gene_lengths=getlength(names(genes),"hg18","ensGene")
## pwf=nullp(genes,bias.data=gene_lengths)
## go_map=getgo(names(genes),"hg18","ensGene")
## go=goseq(pwf,"hg18","ensGene",gene2cat=go_map)


###################################################
### chunk number 26: KEGG_mappings eval=FALSE
###################################################
## #line 314 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## #Get the mapping from ENSEMBL 2 Entrez
## en2eg=as.list(org.Hs.egENSEMBL2EG)
## #Get the mapping from Entrez 2 KEGG
## eg2kegg=as.list(org.Hs.egPATH)
## #Define a function which gets all unique KEGG IDs associated with a set of Entrez IDs
## grepKEGG=function(id,mapkeys){unique(unlist(mapkeys[id],use.names=FALSE))}
## #Apply this function to every entry in the mapping from ENSEMBL 2 Entrez to combine the two maps
## kegg=lapply(en2eg,grepKEGG,eg2kegg)
## head(kegg)


###################################################
### chunk number 27: KEGG eval=FALSE
###################################################
## #line 330 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
## pwf=nullp(genes,"hg18","ensGene")
## KEGG=goseq(pwf,gene2cat=kegg)
## head(KEGG)


###################################################
### chunk number 28: KEGG_goseq
###################################################
#line 340 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
pwf=nullp(genes,'hg18','ensGene')
KEGG=goseq(pwf,'hg18','ensGene',test.cats="KEGG")
head(KEGG)


###################################################
### chunk number 29: KEGG_from_db
###################################################
#line 352 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
kegg=as.list(org.Hs.egPATH)
head(kegg)


###################################################
### chunk number 30: countbias
###################################################
#line 367 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
countbias=rowSums(counts)[rowSums(counts)!=0]
length(countbias)
length(genes)


###################################################
### chunk number 31: GO.counts
###################################################
#line 375 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
pwf.counts=nullp(genes,bias.data=countbias)
GO.counts=goseq(pwf.counts,"hg18","ensGene")
head(GO.counts)


###################################################
### chunk number 32: setup
###################################################
#line 386 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp7bMhmg/R.INSTALL6ca31b3b/goseq/inst/doc/goseq.Rnw"
sessionInfo()


