###################################################
### chunk number 1: install eval=FALSE
###################################################
## #line 56 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite(c("gage","gageData"))


###################################################
### chunk number 2: install eval=FALSE
###################################################
## #line 63 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## install.packages(c("/your/local/directory/gage_2.0.0.tar.gz",
##     "/your/local/directory/gageData_1.0.0.tar.gz"), 
##     repos = NULL, type = "source")


###################################################
### chunk number 3: start
###################################################
#line 73 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
options(width=80)


###################################################
### chunk number 4: start
###################################################
#line 77 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
library(gage)


###################################################
### chunk number 5: start eval=FALSE
###################################################
## #line 82 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## library(help=gage)


###################################################
### chunk number 6: start eval=FALSE
###################################################
## #line 87 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## help(gage)
## ?gage


###################################################
### chunk number 7: dataPrep
###################################################
#line 96 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
data(gse16873)
cn=colnames(gse16873)
hn=grep('HN',cn, ignore.case =T)
adh=grep('ADH',cn, ignore.case =T)
dcis=grep('DCIS',cn, ignore.case =T)
print(hn)
print(dcis)


###################################################
### chunk number 8: dataPrep
###################################################
#line 111 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
data(kegg.gs)
data(go.gs)
lapply(kegg.gs[1:3],head)
head(rownames(gse16873))


###################################################
### chunk number 9: gage.1direction
###################################################
#line 122 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
gse16873.kegg.p <- gage(gse16873, gsets = kegg.gs, 
    ref = hn, samp = dcis)
#go.gs here only the first 1000 entries as a fast example.
gse16873.go.p <- gage(gse16873, gsets = go.gs, 
    ref = hn, samp = dcis)
str(gse16873.kegg.p, strict.width='wrap')
head(gse16873.kegg.p$greater[, 1:5], 4)
head(gse16873.kegg.p$less[, 1:5], 4)


###################################################
### chunk number 10: gage.2direction
###################################################
#line 135 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
gse16873.kegg.2d.p <- gage(gse16873, gsets = kegg.gs, 
    ref = hn, samp = dcis, same.dir = F)
head(gse16873.kegg.2d.p[,1:5], 4)


###################################################
### chunk number 11: page
###################################################
#line 143 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
gse16873.kegg.page.p <- gage(gse16873, gsets = kegg.gs, 
    ref = hn, samp = dcis, saaTest = gs.zTest)
head(gse16873.kegg.page.p$greater[, 1:5], 4)


###################################################
### chunk number 12: gage.alternative eval=FALSE
###################################################
## #line 153 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## gse16873.kegg.t.p <- gage(gse16873, gsets = kegg.gs, 
##     ref = hn, samp = dcis, use.fold = F)


###################################################
### chunk number 13: gage.alternative eval=FALSE
###################################################
## #line 159 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## gse16873.kegg.rk.p <- gage(gse16873, gsets = kegg.gs, 
##     ref = hn, samp = dcis, rank.test = T)


###################################################
### chunk number 14: gage.alternative eval=FALSE
###################################################
## #line 165 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## gse16873.kegg.ks.p <- gage(gse16873, gsets = kegg.gs, 
##     ref = hn, samp = dcis, saaTest = gs.KSTest)


###################################################
### chunk number 15: gage.alternative eval=FALSE
###################################################
## #line 171 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
## gse16873.kegg.unpaired.p <- gage(gse16873, gsets = kegg.gs, 
##     ref = hn, samp = dcis, compare = "unpaired")


###################################################
### chunk number 16: symbol.ID
###################################################
#line 177 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
head(rownames(gse16873))
gse16873.sym<-gse16873
data(egSymb)
rownames(gse16873.sym)<-eg2sym(rownames(gse16873.sym))
head(rownames(gse16873.sym))


###################################################
### chunk number 17: symbol.ID
###################################################
#line 186 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
kegg.gs.sym<-lapply(kegg.gs, eg2sym)
lapply(kegg.gs.sym[1:3],head)
gse16873.kegg.p2 <- gage(gse16873.sym, gsets = kegg.gs.sym, 
    ref = hn, samp = dcis)


###################################################
### chunk number 18: full.table
###################################################
#line 197 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
write.table(gse16873.kegg.2d.p, file = "gse16873.kegg.2d.p.txt", 
    sep = "\t")
write.table(rbind(gse16873.kegg.p$greater, gse16873.kegg.p$less), 
    file = "gse16873.kegg.p.txt", sep = "\t")


###################################################
### chunk number 19: significant.genesets
###################################################
#line 205 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
gse16873.kegg.sig<-sigGeneSet(gse16873.kegg.p, dualSig=1)
str(gse16873.kegg.sig, strict.width='wrap')
gse16873.kegg.2d.sig<-sigGeneSet(gse16873.kegg.2d.p)
str(gse16873.kegg.2d.sig, strict.width='wrap')
write.table(gse16873.kegg.sig, file = "gse16873.kegg.sig.txt", 
    sep = "\t")
write.table(gse16873.kegg.2d.sig, file = "gse16873.kegg.2d.sig.txt", 
    sep = "\t")


###################################################
### chunk number 20: nonredundant.genesets
###################################################
#line 217 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
gse16873.kegg.esg.up <- esset.grp(gse16873.kegg.p$greater, 
    gse16873, gsets = kegg.gs, ref = hn, samp = dcis, 
    test4up = T, output = T, outname = "gse16873.kegg.up", make.plot = F)
gse16873.kegg.esg.dn <- esset.grp(gse16873.kegg.p$less, 
    gse16873, gsets = kegg.gs, ref = hn, samp = dcis, 
    test4up = F, output = T, outname = "gse16873.kegg.dn", make.plot = F)
names(gse16873.kegg.esg.up)
head(gse16873.kegg.esg.up$essentialSets, 4)
head(gse16873.kegg.esg.up$setGroups, 4)
head(gse16873.kegg.esg.up$coreGeneSets, 4)


###################################################
### chunk number 21: gene.expression
###################################################
#line 231 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
rownames(gse16873.kegg.p$greater)[1:3]
gs=unique(unlist(kegg.gs[rownames(gse16873.kegg.p$greater)[1:3]]))
essData=essGene(gs, gse16873, ref =hn, samp =dcis)
head(essData, 4)
ref1=1:6
samp1=7:12
for (gs in rownames(gse16873.kegg.p$greater)[1:3]) {
    outname = gsub(" |:|/", "_", substr(gs, 10, 100))
    geneData(genes = kegg.gs[[gs]], exprs = essData, ref = ref1, 
        samp = samp1, outname = outname, txt = T, heatmap = T, 
        Colv = F, Rowv = F, dendrogram = "none", limit = 3, scatterplot = T)
}


###################################################
### chunk number 22: gagePipe
###################################################
#line 260 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
#introduce another half dataset
library(gageData)
data(gse16873.2)
cn2=colnames(gse16873.2)
hn2=grep('HN',cn2, ignore.case =T)
dcis2=grep('DCIS',cn2, ignore.case =T)
#batch GAGE analysis on the combined dataset
gse16873=cbind(gse16873, gse16873.2)
dataname='gse16873' #output data prefix
sampnames=c('dcis.1', 'dcis.2')
refList=list(hn, hn2+12)
sampList=list(dcis, dcis2+12)
gagePipe(gse16873, gsname = "kegg.gs", dataname = "gse16873", 
    sampnames = sampnames, ref.list = refList, samp.list = sampList, 
    comp.list = "paired")


###################################################
### chunk number 23: gageComp
###################################################
#line 279 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
load('gse16873.gage.RData')
gageComp(sampnames, dataname, gsname = "kegg.gs", 
    do.plot = TRUE)


###################################################
### chunk number 24: heter.gage
###################################################
#line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpoi417k/R.INSTALL7e43fe/gage/inst/doc/gage.Rnw"
boxplot(data.frame(gse16873))
gse16873.kegg.heter.p <- heter.gage(gse16873, gsets = kegg.gs, 
    ref.list = refList, samp.list = sampList)
gse16873.kegg.heter.2d.p <- heter.gage(gse16873, gsets = kegg.gs, 
    ref.list = refList, samp.list = sampList, same.dir = F)


