###################################################
### chunk number 1: loadGvHD
###################################################
#line 57 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
library(flowStats)
data(ITN)


###################################################
### chunk number 2: transform
###################################################
#line 70 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
wf <- workFlow(ITN)
tl <- transformList(colnames(ITN)[3:7], asinh, transformationId="asinh")
add(wf, tl)


###################################################
### chunk number 3: lymphGate
###################################################
#line 93 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
lg <- lymphGate(Data(wf[["asinh"]]), channels=c("SSC", "CD3"),
                preselection="CD4", filterId="TCells", eval=FALSE,
                scale=2.5)
add(wf, lg$n2gate, parent="asinh")


###################################################
### chunk number 4: lymphGatePlot
###################################################
#line 98 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
library(flowViz)
print(xyplot(SSC ~ CD3| PatientID, wf[["TCells+"]],
      par.settings=list(gate=list(col="red", 
         fill="red", alpha=0.3))))


###################################################
### chunk number 5: variation
###################################################
#line 117 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
pars <- colnames(Data(wf[["base view"]]))[c(3,4,5,7)]
print(densityplot(PatientID~., Data(wf[["TCells+"]]), channels=pars, groups=GroupID,
                  scales=list(y=list(draw=F)), filter=lapply(pars, curv1Filter),
                  layout=c(4,1)))


###################################################
### chunk number 6: norm
###################################################
#line 154 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
norm <- normalization(normFun=function(x, parameters, ...)
                      warpSet(x, parameters, ...),
                      parameters=pars,
                      arguments=list(grouping="GroupID", monwrd=TRUE),
                      normalizationId="Warping")
add(wf, norm, parent="TCells+")


###################################################
### chunk number 7: normPlot
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
print(densityplot(PatientID~., Data(wf[["Warping"]]), channels=pars, groups=GroupID,
                  scales=list(y=list(draw=F)), filter=lapply(pars, curv1Filter),
                  layout=c(4,1)))


###################################################
### chunk number 8: quadGate
###################################################
#line 174 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
qgate <- quadrantGate(Data(wf[["Warping"]]), stains=c("CD4", "CD8"),
                      filterId="CD4CD8", sd=3)
add(wf, qgate, parent="Warping")


###################################################
### chunk number 9: quadGatePlot
###################################################
#line 179 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
print(xyplot(CD8 ~ CD4 | PatientID, wf[["CD4+CD8+"]],
             par.settings=list(gate=list(fill="transparent", 
                               col="red"))))


###################################################
### chunk number 10: rangeGate
###################################################
#line 190 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
CD69rg <- rangeGate(Data(wf[["Warping"]]), stain="CD69",
                    alpha=0.75, filterId="CD4+CD8-CD69", sd=2.5)
add(wf, CD69rg, parent="CD4+CD8-")


###################################################
### chunk number 11: rangeGatePlot
###################################################
#line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
print(densityplot(PatientID ~ CD69, Data(wf[["CD4+CD8-"]]), main = "CD4+",
            groups=GroupID, refline=CD69rg@min))


###################################################
### chunk number 12: createData
###################################################
#line 224 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
dat <- Data(wf[["Warping"]])



###################################################
### chunk number 13: rawData
###################################################
#line 230 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
print( xyplot(CD8 ~ CD4 , dat, main= "Experimental data set"))


###################################################
### chunk number 14: createControlData
###################################################
#line 239 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
datComb <- as(dat,"flowFrame")
subCount <- nrow(exprs(datComb))/length(dat)
	sf <- sampleFilter(filterId="mySampleFilter", size=subCount)
	fres <- filter(datComb, sf)
	ctrlData <- Subset(datComb, fres)
	ctrlData <- ctrlData[,-ncol(ctrlData)] ##remove the  column name "original"
	


###################################################
### chunk number 15: BinControlData
###################################################
#line 253 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
minRow=subCount*0.05
refBins<-proBin(ctrlData,minRow,channels=c("CD4","CD8"))
	


###################################################
### chunk number 16: controlBinsPlot
###################################################
#line 264 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
plotBins(refBins,ctrlData,channels=c("CD4","CD8"),title="Control Data")



###################################################
### chunk number 17: binSampleData
###################################################
#line 272 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
sampBins <- fsApply(dat,function(x){
		   binByRef(refBins,x)
		   })


###################################################
### chunk number 18: pearsonStat
###################################################
#line 282 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
pearsonStat <- lapply(sampBins,function(x){
		      calcPearsonChi(refBins,x)
                     })


###################################################
### chunk number 19: Roderers PBin metric
###################################################
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
sCount <- fsApply(dat,nrow)
pBStat <-lapply(seq_along(sampBins),function(x){
		calcPBChiSquare(refBins,sampBins[[x]],subCount,sCount[x])
		})


###################################################
### chunk number 20: plotBinsresiduals
###################################################
#line 301 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
par(mfrow=c(4,4),mar=c(1.5,1.5,1.5,1.5))

plotBins(refBins,ctrlData,channels=c("CD4","CD8"),title="Control Data")
patNames <-sampleNames(dat)
tm<-lapply(seq_len(length(dat)),function(x){
		plotBins(refBins,dat[[x]],channels=c("CD4","CD8"),
			title=patNames[x],
			residuals=pearsonStat[[x]]$residuals[2,],
			shadeFactor=0.7)
		
		}
      )


###################################################
### chunk number 21: chiSqstatisticvalues
###################################################
#line 321 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
library(xtable)
chi_Square_Statistic <- unlist(lapply(pearsonStat,function(x){
		x$statistic
		}))

pBin_Statistic <-unlist(lapply(pBStat,function(x){
                x$pbStat
						                        })) 
	
frame <- data.frame(chi_Square_Statistic, pBin_Statistic)
rownames(frame) <- patNames
 	


###################################################
### chunk number 22: 
###################################################
#line 336 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
print(xtable(frame))


###################################################
### chunk number 23: 
###################################################
#line 343 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpxHEGA1/R.INSTALL6f0860d7/flowStats/inst/doc/GettingStartedWithFlowStats.Rnw"
toLatex(sessionInfo())


