###################################################
### chunk number 1: set width
###################################################
#line 29 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
options(width=60)
options(continue=" ")
try(X11.options(type="xlib"), silent=TRUE)


###################################################
### chunk number 2: load the packages
###################################################
#line 65 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
library(eisa)


###################################################
### chunk number 3: load the data
###################################################
#line 71 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
library(ALL)
library(hgu95av2.db)
library(affy)
data(ALL)


###################################################
### chunk number 4: simple ISA
###################################################
#line 94 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
thr.gene <- 2.7
thr.cond <- 1.4
set.seed(1) # to get the same results, always
# modules <- ISA(ALL, thr.gene=thr.gene, thr.cond=thr.cond)
data(ALLModulesSmall)
modules <- ALLModulesSmall


###################################################
### chunk number 5: type in name of ISAModules object
###################################################
#line 112 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules


###################################################
### chunk number 6: accessors 1
###################################################
#line 124 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
length(modules)
dim(modules)


###################################################
### chunk number 7: accessors 2
###################################################
#line 132 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
featureNames(modules)[1:5]
sampleNames(modules)[1:5]


###################################################
### chunk number 8: number of features and samples
###################################################
#line 145 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
getNoFeatures(modules)
getNoSamples(modules)
colnames(pData(modules))
getOrganism(modules)
annotation(modules)


###################################################
### chunk number 9: indexing
###################################################
#line 157 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules[[1:5]]


###################################################
### chunk number 10: indexing 2
###################################################
#line 165 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
chr <- get(paste(annotation(modules), sep="", "CHR"))
chr1features <- sapply(mget(featureNames(modules), chr), 
                 function(x) "1" %in% x)
modules[chr1features,]


###################################################
### chunk number 11: indexing 3
###################################################
#line 173 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules[ ,grep("^B", pData(modules)$BT)]


###################################################
### chunk number 12: list genes in modules
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
getFeatureNames(modules)[[1]]


###################################################
### chunk number 13: list conditions in modules
###################################################
#line 187 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
getSampleNames(modules)[[1]]


###################################################
### chunk number 14: query scores
###################################################
#line 201 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
getFeatureScores(modules, 3)
getSampleScores(modules, 3)


###################################################
### chunk number 15: query all scores
###################################################
#line 211 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
dim(getFeatureMatrix(modules))
dim(getSampleMatrix(modules))


###################################################
### chunk number 16: seed data
###################################################
#line 223 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
seedData(modules)


###################################################
### chunk number 17: run data
###################################################
#line 229 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
runData(modules)


###################################################
### chunk number 18: GO enrichment
###################################################
#line 248 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
GO <- ISAGO(modules)


###################################################
### chunk number 19: list GO result
###################################################
#line 259 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
GO


###################################################
### chunk number 20: GO summary
###################################################
#line 274 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
summary(GO$BP, p=0.001)[[1]][,-6]


###################################################
### chunk number 21: GO gene ids by category
###################################################
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
geneIdsByCategory(GO$BP)[[1]][[3]]


###################################################
### chunk number 22: GO info
###################################################
#line 294 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
sigCategories(GO$BP)[[1]]
library(GO.db)
mget(na.omit(sigCategories(GO$BP)[[1]][1:3]), GOTERM)


###################################################
### chunk number 23: KEGG enrichment
###################################################
#line 325 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
KEGG <- ISAKEGG(modules)
KEGG
summary(KEGG, p=1e-3)[[1]]
library(KEGG.db)
mget(sigCategories(KEGG, p=0.001)[[1]], KEGGPATHID2NAME)


###################################################
### chunk number 24: CHR enrichment
###################################################
#line 342 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
CHR <- ISACHR(modules)
summary(CHR,p=0.05)[[2]][,-6]


###################################################
### chunk number 25: CHR enrichment list
###################################################
#line 351 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
unlist(mget(geneIdsByCategory(CHR)[[2]][[1]], org.Hs.egSYMBOL))


###################################################
### chunk number 26: miRNA enrichment
###################################################
#line 373 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
if (require(targetscan.Hs.eg.db)) {
  miRNA <- ISAmiRNA(modules)
  summary(miRNA, p=0.1)[[7]]
}


###################################################
### chunk number 27: biclust
###################################################
#line 400 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
library(biclust)
Bc <- as(modules, "Biclust")
Bc


###################################################
### chunk number 28: heatmap eval=FALSE
###################################################
## #line 417 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## ISA2heatmap(modules, 1, ALL, norm="sample", scale="none", 
##             col=heat.colors(12))


###################################################
### chunk number 29: heatmap-cb eval=FALSE
###################################################
## #line 423 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## sc <- function(x, ab) {
##   x <- x-min(x)
##   r <- range(x) 
##   x <- x/(r[2]-r[1])
##   x * (ab[2]-ab[1]) + ab[1]
## }
## cb <- sc(1:12, range(exprs(ALL)[getFeatureNames(modules, 1)[[1]],
##                                       getSampleNames(modules, 2)[[1]] ]))
## par(mar=c(3,4,5,2)+0.1)
## image(rbind(cb), axes=FALSE)
## axis(2, at=sc(1:12, 0:1), cb, label=format(cb, digits=2))


###################################################
### chunk number 30: save heatmap files
###################################################
#line 439 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
png("plot-heatmap.png", 400, 400)
#line 417 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw#from line#440#"
ISA2heatmap(modules, 1, ALL, norm="sample", scale="none", 
            col=heat.colors(12))
#line 441 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
dev.off()
png("plot-heatmap-colorbar.png", 100, 400)
#line 423 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw#from line#443#"
sc <- function(x, ab) {
  x <- x-min(x)
  r <- range(x) 
  x <- x/(r[2]-r[1])
  x * (ab[2]-ab[1]) + ab[1]
}
cb <- sc(1:12, range(exprs(ALL)[getFeatureNames(modules, 1)[[1]],
                                      getSampleNames(modules, 2)[[1]] ]))
par(mar=c(3,4,5,2)+0.1)
image(rbind(cb), axes=FALSE)
axis(2, at=sc(1:12, 0:1), cb, label=format(cb, digits=2))
#line 444 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
dev.off()


###################################################
### chunk number 31: parallel.pre
###################################################
#line 468 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
png("plot-parallel.png", 400, 400 )


###################################################
### chunk number 32: parallel
###################################################
#line 471 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
profilePlot(modules, 2, ALL, plot="both")


###################################################
### chunk number 33: parallel.post
###################################################
#line 474 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
dev.off()


###################################################
### chunk number 34: goplot1
###################################################
#line 507 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
goplot.2 <- gograph(summary(GO$BP, p=0.05)[[1]])


###################################################
### chunk number 35: gograph object
###################################################
#line 514 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
summary(goplot.2)


###################################################
### chunk number 36: gograph object 2
###################################################
#line 521 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
goplot.2$width
goplot.2$height


###################################################
### chunk number 37: goplot2 eval=FALSE
###################################################
## #line 528 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## x11(width=10, height=10*goplot.2$height/goplot.2$width)
## gographPlot(goplot.2)


###################################################
### chunk number 38: goplot2-real eval=FALSE
###################################################
## #line 533 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## ps.options(fonts=c("serif", "mono"))
## gographPlot(goplot.2)


###################################################
### chunk number 39: goplot2-real-real
###################################################
#line 540 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
#line 533 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw#from line#540#"
ps.options(fonts=c("serif", "mono"))
gographPlot(goplot.2)
#line 541 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"


###################################################
### chunk number 40: goplot names
###################################################
#line 555 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
V(goplot.2)$abbrv[1:5]
lapply(V(goplot.2)$desc[1:5], strwrap)


###################################################
### chunk number 41: condplot eval=FALSE
###################################################
## #line 576 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## col <- ifelse( grepl("^B", pData(modules)$BT), "darkolivegreen", "orange")
## condPlot(modules, 2, ALL, col=col)


###################################################
### chunk number 42: condplot-real
###################################################
#line 584 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
#line 576 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw#from line#584#"
col <- ifelse( grepl("^B", pData(modules)$BT), "darkolivegreen", "orange")
condPlot(modules, 2, ALL, col=col)
#line 585 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"


###################################################
### chunk number 43: HTML1
###################################################
#line 612 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
htmldir <- tempdir()
ISAHTMLTable(modules=modules, target.dir=htmldir, 
             GO=GO, KEGG=KEGG, CHR=CHR)


###################################################
### chunk number 44: HTML2 eval=FALSE
###################################################
## #line 617 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## if (interactive()) {
##   browseURL(URLencode(paste("file://", htmldir, "/maintable.html", sep="")))
## }


###################################################
### chunk number 45: HTML modules
###################################################
#line 656 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
ISAHTMLModules(eset=ALL, modules=modules, target.dir=htmldir,
               GO=GO, KEGG=KEGG, CHR=CHR)


###################################################
### chunk number 46: coherence
###################################################
#line 795 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
constantVariance(exprs(ALL), Bc, number=1)
additiveVariance(exprs(ALL), Bc, number=1)
multiplicativeVariance(exprs(ALL), Bc, number=1)
signVariance(exprs(ALL), Bc, number=1)


###################################################
### chunk number 47: coherence all
###################################################
#line 805 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
cv <- sapply(seq_len(Bc@Number), 
             function(x) constantVariance(exprs(ALL), Bc, number=x))
av <- sapply(seq_len(Bc@Number), 
             function(x) additiveVariance(exprs(ALL), Bc, number=x))
cor(av, cv)


###################################################
### chunk number 48: robustness
###################################################
#line 834 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
seedData(modules)$rob


###################################################
### chunk number 49: filtering
###################################################
#line 885 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
varLimit <- 0.5
kLimit <- 4
ALimit <- 5
flist <- filterfun(function(x) var(x)>varLimit, kOverA(kLimit,ALimit))
ALL.filt <- ALL[genefilter(ALL, flist), ]


###################################################
### chunk number 50: Entrez
###################################################
#line 901 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
ann <- annotation(ALL.filt)
library(paste(ann, sep=".", "db"), character.only=TRUE)
ENTREZ <- get( paste(ann, sep="", "ENTREZID") )
EntrezIds <- mget(featureNames(ALL.filt), ENTREZ)
keep <- sapply(EntrezIds, function(x) length(x) >= 1 && !is.na(x))
ALL.filt.2 <- ALL.filt[keep,]


###################################################
### chunk number 51: Entrez unique
###################################################
#line 913 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
vari <- apply(exprs(ALL.filt.2), 1, var)
larg <- findLargest(featureNames(ALL.filt.2), vari, data=annotation(ALL.filt.2))
ALL.filt.3 <- ALL.filt.2[larg,]


###################################################
### chunk number 52: normed
###################################################
#line 931 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
ALL.normed <- ISANormalize(ALL.filt.3)
ls(assayData(ALL.normed))
dim(featExprs(ALL.normed))
dim(sampExprs(ALL.normed))


###################################################
### chunk number 53: seeds
###################################################
#line 950 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
set.seed(3)
random.seeds <- generate.seeds(length=nrow(ALL.normed), count=100)


###################################################
### chunk number 54: smart seeds
###################################################
#line 961 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
type <- as.character(pData(ALL.normed)$BT)
ss1 <- ifelse(grepl("^B", type), -1, 1)
ss2 <- ifelse(grepl("^B1", type), 1, 0)
ss3 <- ifelse(grepl("^B2", type), 1, 0)
ss4 <- ifelse(grepl("^B3", type), 1, 0)
ss5 <- ifelse(grepl("^B4", type), 1, 0)
ss6 <- ifelse(grepl("^T1", type), 1, 0)
ss7 <- ifelse(grepl("^T2", type), 1, 0)
ss8 <- ifelse(grepl("^T3", type), 1, 0)
ss9 <- ifelse(grepl("^T4", type), 1, 0)
smart.seeds <- cbind(ss1, ss2, ss3, ss4, ss5, ss6, ss7, ss8, ss9)


###################################################
### chunk number 55: iteration
###################################################
#line 987 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules1 <- ISAIterate(ALL.normed, feature.seeds=random.seeds, 
                        thr.feat=1.5, thr.samp=1.8, convergence="cor")
modules2 <- ISAIterate(ALL.normed, sample.seeds=smart.seeds,
                        thr.feat=1.5, thr.samp=1.8, convergence="cor")


###################################################
### chunk number 56: unique
###################################################
#line 1005 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules1.unique <- ISAUnique(ALL.normed, modules1)
modules2.unique <- ISAUnique(ALL.normed, modules2)
length(modules1.unique)
length(modules2.unique)


###################################################
### chunk number 57: robust
###################################################
#line 1022 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules1.robust <- ISAFilterRobust(ALL.normed, modules1.unique)
modules2.robust <- ISAFilterRobust(ALL.normed, modules2.unique)
length(modules1.robust)
length(modules2.robust)


###################################################
### chunk number 58: B vs T
###################################################
#line 1047 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
scores1 <- getSampleMatrix(modules1.robust)
tt1 <- colttests(scores1, as.factor(substr(type, 1, 1)))
scores2 <- getSampleMatrix(modules2.robust)
tt2 <- colttests(scores2, as.factor(substr(type, 1, 1)))
sign1 <- which(p.adjust(tt1$p.value, "holm") < 0.05)
sign2 <- which(p.adjust(tt2$p.value, "holm") < 0.05)
sign1
sign2


###################################################
### chunk number 59: conditions-plots-dysreg eval=FALSE
###################################################
## #line 1064 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## color <- ifelse(grepl("T", type), "orange", "darkolivegreen")
## layout(cbind(1:2))
## condPlot(modules1.robust, which.min(tt1$p.value), ALL.normed, col=color, 
##           main="Best separator, random seeds")
## condPlot(modules2.robust, which.min(tt2$p.value), ALL.normed, col=color,
##           main="Best separator, smart seeds")


###################################################
### chunk number 60: conditions-plots-dysreg-real
###################################################
#line 1074 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
#line 1064 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw#from line#1074#"
color <- ifelse(grepl("T", type), "orange", "darkolivegreen")
layout(cbind(1:2))
condPlot(modules1.robust, which.min(tt1$p.value), ALL.normed, col=color, 
          main="Best separator, random seeds")
condPlot(modules2.robust, which.min(tt2$p.value), ALL.normed, col=color,
          main="Best separator, smart seeds")
#line 1075 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"


###################################################
### chunk number 61: extract separators
###################################################
#line 1085 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
modules1.TB <- modules1.robust[[sign1]]
modules2.TB <- modules2.robust[[sign2]]


###################################################
### chunk number 62: dysreg correlation
###################################################
#line 1093 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
cor(getSampleMatrix(modules1.TB), getSampleMatrix(modules2.TB))
cor(getFeatureMatrix(modules1.TB), getFeatureMatrix(modules2.TB))


###################################################
### chunk number 63: dysreg enrichment
###################################################
#line 1103 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
GO.dysreg1 <- ISAGO(modules1.TB)
GO.dysreg2 <- ISAGO(modules2.TB)
KEGG.dysreg1 <- ISAKEGG(modules1.TB)
KEGG.dysreg2 <- ISAKEGG(modules2.TB)


###################################################
### chunk number 64: dysreg enriched categories
###################################################
#line 1112 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
gocats <- unique(unlist(c(sigCategories(GO.dysreg1$BP),
                          sigCategories(GO.dysreg1$CC),
                          sigCategories(GO.dysreg1$MF),
                          sigCategories(GO.dysreg2$BP),
                          sigCategories(GO.dysreg2$CC),
                          sigCategories(GO.dysreg2$MF))))
keggp <- unique(unlist(c(sigCategories(KEGG.dysreg1), 
                         sigCategories(KEGG.dysreg2))))
sapply(mget(gocats, GOTERM), Term)
mget(keggp, KEGGPATHID2NAME)


###################################################
### chunk number 65: B1 vs others
###################################################
#line 1130 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
keep <- grepl("^B[1234]", type)
type.B <- ifelse(type[keep]=="B1", "B1", "Bx")
scores.B1.1 <- scores1[keep,]
scores.B1.2 <- scores2[keep,]
tt.B1.1 <- colttests(scores.B1.1, as.factor(type.B))
tt.B1.2 <- colttests(scores.B1.2, as.factor(type.B))
min(p.adjust(na.omit(tt.B1.1$p.value)))
min(p.adjust(na.omit(tt.B1.2$p.value)))


###################################################
### chunk number 66: B1-cond-plots eval=FALSE
###################################################
## #line 1143 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
## color <- ifelse(type == "B1", "green", 
##                 ifelse(grepl("^T", type), "orange", "darkolivegreen"))
## layout(cbind(1:2))
## condPlot(modules1.robust, which.min(tt.B1.1$p.value), ALL.normed, col=color, 
##           main="Best B1 separator, random seeds")
## condPlot(modules2.robust, which.min(tt.B1.2$p.value), ALL.normed, col=color,
##           main="Best B1 separator, smart seeds")


###################################################
### chunk number 67: B1-cond-plots-real
###################################################
#line 1155 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
#line 1143 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw#from line#1155#"
color <- ifelse(type == "B1", "green", 
                ifelse(grepl("^T", type), "orange", "darkolivegreen"))
layout(cbind(1:2))
condPlot(modules1.robust, which.min(tt.B1.1$p.value), ALL.normed, col=color, 
          main="Best B1 separator, random seeds")
condPlot(modules2.robust, which.min(tt.B1.2$p.value), ALL.normed, col=color,
          main="Best B1 separator, smart seeds")
#line 1156 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"


###################################################
### chunk number 68: check B1 same module
###################################################
#line 1166 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
B1.cor <- c(cor(scores1[,which.min(tt.B1.1$p.value)],
                scores2[,which.min(tt.B1.2$p.value)]),
            cor(getFeatureMatrix(modules1.robust, 
                                 mods=which.min(tt.B1.1$p.value)),
                getFeatureMatrix(modules2.robust, 
                                 mods=which.min(tt.B1.2$p.value))))
B1.cor


###################################################
### chunk number 69: sessioninfo
###################################################
#line 1192 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_tutorial.Rnw"
toLatex(sessionInfo())


